package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefValeurQualitativeEDIModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefValeurQualitativeEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDI;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDIImpl;

/**
 * repository_id;reference_id;reference_param;reference_code;reference_label;source
 * 
 * @author Eric Chatellier
 */
public class RefValeurQualitativeEDIModel extends AbstractAgrosystModel<RefValeurQualitativeEDI> implements ExportModel<RefValeurQualitativeEDI> {

    public RefValeurQualitativeEDIModel() {
        super(';');
        
        newMandatoryColumn("repository_id", RefValeurQualitativeEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefValeurQualitativeEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefValeurQualitativeEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefValeurQualitativeEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefValeurQualitativeEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefValeurQualitativeEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefValeurQualitativeEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefValeurQualitativeEDI> modelBuilder = new ModelBuilder<RefValeurQualitativeEDI>();
        modelBuilder.newColumnForExport("repository_id", RefValeurQualitativeEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefValeurQualitativeEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefValeurQualitativeEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefValeurQualitativeEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefValeurQualitativeEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefValeurQualitativeEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefValeurQualitativeEDI newEmptyInstance() {
        return new RefValeurQualitativeEDIImpl();
    }
}
