package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefUnitesQualifiantEDIModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefUnitesQualifiantEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDI;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDIImpl;

/**
 * repository_id;reference_id;reference_param;reference_code;reference_label;source
 * 
 * @author Eric Chatellier
 */
public class RefUnitesQualifiantEDIModel extends AbstractAgrosystModel<RefUnitesQualifiantEDI> implements ExportModel<RefUnitesQualifiantEDI> {

    public RefUnitesQualifiantEDIModel() {
        super(';');
        
        newMandatoryColumn("repository_id", RefUnitesQualifiantEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefUnitesQualifiantEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefUnitesQualifiantEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefUnitesQualifiantEDI> modelBuilder = new ModelBuilder<RefUnitesQualifiantEDI>();
        modelBuilder.newColumnForExport("repository_id", RefUnitesQualifiantEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefUnitesQualifiantEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefUnitesQualifiantEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefUnitesQualifiantEDI newEmptyInstance() {
        return new RefUnitesQualifiantEDIImpl();
    }
}
