package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefUniteEDIModel.java 3571 2014-03-03 15:23:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefUniteEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefUniteEDI;
import fr.inra.agrosyst.api.entities.referential.RefUniteEDIImpl;

/**
 * @author David Cossé
 */
public class RefUniteEDIModel extends AbstractAgrosystModel<RefUniteEDI> implements ExportModel<RefUniteEDI> {

    public RefUniteEDIModel() {
        super(';');

        newMandatoryColumn("repository_id", RefUniteEDI.PROPERTY_REPOSITORY_ID, INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("reference_id", RefUniteEDI.PROPERTY_REFERENCE_ID, INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("reference_param",RefUniteEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefUniteEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefUniteEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefUniteEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefUniteEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefUniteEDI> modelBuilder = new ModelBuilder<RefUniteEDI>();
        modelBuilder.newColumnForExport("repository_id",  RefUniteEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefUniteEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefUniteEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefUniteEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefUniteEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefUniteEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefUniteEDI newEmptyInstance() {
        return new RefUniteEDIImpl();
    }
}
