package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefTypeTravailEDIModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefTypeTravailEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDIImpl;

/**
 * @author cosse
 *
 */
public class RefTypeTravailEDIModel extends AbstractAgrosystModel<RefTypeTravailEDI> implements ExportModel<RefTypeTravailEDI> {

    public RefTypeTravailEDIModel() {
        super(';');
        newMandatoryColumn("repository_id", RefTypeTravailEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefTypeTravailEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefTypeTravailEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefTypeTravailEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefTypeTravailEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("Source", RefTypeTravailEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefTypeTravailEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefTypeTravailEDI> modelBuilder = new ModelBuilder<RefTypeTravailEDI>();
        
        modelBuilder.newColumnForExport("repository_id", RefTypeTravailEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefTypeTravailEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefTypeTravailEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefTypeTravailEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefTypeTravailEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("Source", RefTypeTravailEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefTypeTravailEDI newEmptyInstance() {
        return new RefTypeTravailEDIImpl();
    }

}
