package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefTypeNotationEDIModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefTypeNotationEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDI;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDIImpl;

/**
 * repository_id;reference_id;reference_param;reference_code;reference_label;source
 * 
 * @author Eric Chatellier
 */
public class RefTypeNotationEDIModel extends AbstractAgrosystModel<RefTypeNotationEDI> implements ExportModel<RefTypeNotationEDI> {

    public RefTypeNotationEDIModel() {
        super(';');
        
        newMandatoryColumn("repository_id", RefTypeNotationEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefTypeNotationEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefTypeNotationEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefTypeNotationEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefTypeNotationEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefTypeNotationEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefTypeNotationEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefTypeNotationEDI> modelBuilder = new ModelBuilder<RefTypeNotationEDI>();
        modelBuilder.newColumnForExport("repository_id", RefTypeNotationEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefTypeNotationEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefTypeNotationEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefTypeNotationEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefTypeNotationEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefTypeNotationEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefTypeNotationEDI newEmptyInstance() {
        return new RefTypeNotationEDIImpl();
    }
}
