package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefTypeAgricultureModel.java 2950 2014-01-29 09:36:59Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefTypeAgricultureModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgricultureImpl;

/**
 * repository_id;reference_id;reference_param;reference_code;reference_label;source
 * 
 * @author Eric Chatellier
 */
public class RefTypeAgricultureModel extends AbstractAgrosystModel<RefTypeAgriculture> implements ExportModel<RefTypeAgriculture> {

    public RefTypeAgricultureModel() {
        super(';');
        
        newMandatoryColumn("repository_id", RefTypeAgriculture.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefTypeAgriculture.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefTypeAgriculture.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefTypeAgriculture.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefTypeAgriculture.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefTypeAgriculture.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefTypeAgriculture, Object>> getColumnsForExport() {
        ModelBuilder<RefTypeAgriculture> modelBuilder = new ModelBuilder<RefTypeAgriculture>();
        modelBuilder.newColumnForExport("repository_id", RefTypeAgriculture.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefTypeAgriculture.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefTypeAgriculture.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefTypeAgriculture.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefTypeAgriculture.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefTypeAgriculture.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefTypeAgriculture newEmptyInstance() {
        return new RefTypeAgricultureImpl();
    }
}
