package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefTraitSdCModel.java 2965 2014-01-29 17:31:37Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefTraitSdCModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.ParseException;

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.GrowingSystemCharacteristicType;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdCImpl;

/**
 * @author Estelle Ancelet
 */
public class RefTraitSdCModel extends AbstractAgrosystModel<RefTraitSdC> implements ExportModel<RefTraitSdC> {

    protected static final ValueParser<GrowingSystemCharacteristicType> GROWING_SYSTEM_CHARACTERISTIC_TYPE_PARSER = new ValueParser<GrowingSystemCharacteristicType>() {
        @Override
        public GrowingSystemCharacteristicType parse(String value) throws ParseException {
            GrowingSystemCharacteristicType result = null;
            if (!Strings.isNullOrEmpty(value)) {
                result = GrowingSystemCharacteristicType.valueOf(value);
            }
            return result;
        }
    };
    
    protected static final ValueFormatter<GrowingSystemCharacteristicType> GROWING_SYSTEM_CHARACTERISTIC_TYPE_FORMATTER = new ValueFormatter<GrowingSystemCharacteristicType>() {
        @Override
        public String format(GrowingSystemCharacteristicType value) {
            return value.name();
        }
    };

    public RefTraitSdCModel() {
        super(';');
        //id_trait;type_trait_sdc;nom_trait
        newMandatoryColumn("id_trait", RefTraitSdC.PROPERTY_ID_TRAIT, INT_PARSER);
        newMandatoryColumn("type_trait_sdc", RefTraitSdC.PROPERTY_TYPE_TRAIT_SDC, GROWING_SYSTEM_CHARACTERISTIC_TYPE_PARSER); 
        newMandatoryColumn("nom_trait", RefTraitSdC.PROPERTY_NOM_TRAIT);
    }

    @Override
    public Iterable<ExportableColumn<RefTraitSdC, Object>> getColumnsForExport() {
        ModelBuilder<RefTraitSdC> modelBuilder = new ModelBuilder<RefTraitSdC>();
        modelBuilder.newColumnForExport("id_trait", RefTraitSdC.PROPERTY_ID_TRAIT, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("type_trait_sdc", RefTraitSdC.PROPERTY_TYPE_TRAIT_SDC, GROWING_SYSTEM_CHARACTERISTIC_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("nom_trait", RefTraitSdC.PROPERTY_NOM_TRAIT);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefTraitSdC newEmptyInstance() {
        return new RefTraitSdCImpl();
    }
}
