package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefSupportOrganeEDIModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefSupportOrganeEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDIImpl;

/**
 * repository_id;reference_id;reference_param;reference_code;reference_label;source
 * 
 * @author Eric Chatellier
 */
public class RefSupportOrganeEDIModel extends AbstractAgrosystModel<RefSupportOrganeEDI> implements ExportModel<RefSupportOrganeEDI> {

    public RefSupportOrganeEDIModel() {
        super(';');
        
        newMandatoryColumn("repository_id", RefSupportOrganeEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefSupportOrganeEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefSupportOrganeEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefSupportOrganeEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefSupportOrganeEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefSupportOrganeEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefSupportOrganeEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefSupportOrganeEDI> modelBuilder = new ModelBuilder<RefSupportOrganeEDI>();
        modelBuilder.newColumnForExport("repository_id", RefSupportOrganeEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefSupportOrganeEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefSupportOrganeEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefSupportOrganeEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefSupportOrganeEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefSupportOrganeEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefSupportOrganeEDI newEmptyInstance() {
        return new RefSupportOrganeEDIImpl();
    }
}
