package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefStationMeteoModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefStationMeteoModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteoImpl;

/**
 * Modele d'import du référentiel station meteo.
 *
 * @author Eric Chatellier
 */
public class RefStationMeteoModel extends AbstractAgrosystModel<RefStationMeteo> implements ExportModel<RefStationMeteo> {

    public RefStationMeteoModel() {
        super(';');

        newMandatoryColumn("commune-site", RefStationMeteo.PROPERTY_COMMUNE_SITE);
        newMandatoryColumn("code postal", RefStationMeteo.PROPERTY_CODE_POSTAL);
        newMandatoryColumn("commune", RefStationMeteo.PROPERTY_COMMUNE);
        newMandatoryColumn("site", RefStationMeteo.PROPERTY_SITE);
        newMandatoryColumn("affectation", RefStationMeteo.PROPERTY_AFFECTATION);
        newMandatoryColumn("point GPS", RefStationMeteo.PROPERTY_POINT_GPS);
        newMandatoryColumn("Source", RefStationMeteo.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefStationMeteo, Object>> getColumnsForExport() {
        ModelBuilder<RefStationMeteo> modelBuilder = new ModelBuilder<RefStationMeteo>();
        modelBuilder.newColumnForExport("commune-site", RefStationMeteo.PROPERTY_COMMUNE_SITE);
        modelBuilder.newColumnForExport("code postal", RefStationMeteo.PROPERTY_CODE_POSTAL);
        modelBuilder.newColumnForExport("commune", RefStationMeteo.PROPERTY_COMMUNE);
        modelBuilder.newColumnForExport("site", RefStationMeteo.PROPERTY_SITE);
        modelBuilder.newColumnForExport("affectation", RefStationMeteo.PROPERTY_AFFECTATION);
        modelBuilder.newColumnForExport("point GPS", RefStationMeteo.PROPERTY_POINT_GPS);
        modelBuilder.newColumnForExport("Source", RefStationMeteo.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefStationMeteo newEmptyInstance() {
        return new RefStationMeteoImpl();
    }
}
