package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefStadeNuisibleEDIModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefStadeNuisibleEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDIImpl;

/**
 * repository_id;reference_id;reference_param;reference_code;reference_label;source
 * 
 * @author Eric Chatellier
 */
public class RefStadeNuisibleEDIModel extends AbstractAgrosystModel<RefStadeNuisibleEDI> implements ExportModel<RefStadeNuisibleEDI> {

    public RefStadeNuisibleEDIModel() {
        super(';');
        
        newMandatoryColumn("repository_id", RefStadeNuisibleEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefStadeNuisibleEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefStadeNuisibleEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefStadeNuisibleEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefStadeNuisibleEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefStadeNuisibleEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefStadeNuisibleEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefStadeNuisibleEDI> modelBuilder = new ModelBuilder<RefStadeNuisibleEDI>();
        modelBuilder.newColumnForExport("repository_id", RefStadeNuisibleEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefStadeNuisibleEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefStadeNuisibleEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefStadeNuisibleEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefStadeNuisibleEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefStadeNuisibleEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefStadeNuisibleEDI newEmptyInstance() {
        return new RefStadeNuisibleEDIImpl();
    }
}
