package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefSolTextureGeppaModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefSolTextureGeppaModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppaImpl;

/**
 * Modele d'import du référentiel sol texture GEPPA:
 * 
 * <ul>
 * <li>abbreviation classes texturales GEPAA
 * <li>classes texturales GEPAA
 * <li>abbreviation INDIGO
 * <li>classe INDIGO
 * <li>Source
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class RefSolTextureGeppaModel extends AbstractAgrosystModel<RefSolTextureGeppa> implements ExportModel<RefSolTextureGeppa> {

    public RefSolTextureGeppaModel() {
        super(';');
        
        newMandatoryColumn("abbreviation classes texturales GEPAA", RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA);
        newMandatoryColumn("classes texturales GEPAA", RefSolTextureGeppa.PROPERTY_CLASSES_TEXTURALES__GEPAA);
        newMandatoryColumn("abbreviation INDIGO", RefSolTextureGeppa.PROPERTY_ABBREVIATION__INDIGO);
        newMandatoryColumn("classe INDIGO", RefSolTextureGeppa.PROPERTY_CLASSE__INDIGO);
        newMandatoryColumn("texture I-Phy", RefSolTextureGeppa.PROPERTY_TEXTURE_IPHY);
        newMandatoryColumn("Source", RefSolTextureGeppa.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefSolTextureGeppa, Object>> getColumnsForExport() {
        ModelBuilder<RefSolTextureGeppa> modelBuilder = new ModelBuilder<RefSolTextureGeppa>();
        modelBuilder.newColumnForExport("abbreviation classes texturales GEPAA", RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA);
        modelBuilder.newColumnForExport("classes texturales GEPAA", RefSolTextureGeppa.PROPERTY_CLASSES_TEXTURALES__GEPAA);
        modelBuilder.newColumnForExport("abbreviation INDIGO", RefSolTextureGeppa.PROPERTY_ABBREVIATION__INDIGO);
        modelBuilder.newColumnForExport("classe INDIGO", RefSolTextureGeppa.PROPERTY_CLASSE__INDIGO);
        modelBuilder.newColumnForExport("texture I-Phy", RefSolTextureGeppa.PROPERTY_TEXTURE_IPHY);
        modelBuilder.newColumnForExport("Source", RefSolTextureGeppa.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefSolTextureGeppa newEmptyInstance() {
        return new RefSolTextureGeppaImpl();
    }
}
