package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefSolProfondeurIndigoModel.java 3571 2014-03-03 15:23:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefSolProfondeurIndigoModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigoImpl;

/**
 * Modele d'import du référentiel sol profondeur INDIGO
 * 
 * <ul>
 * <li>Classe de profondeur INDIGO
 * <li>Profondeur
 * <li>libelle classe
 * <li>h (cm)
 * <li>source
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class RefSolProfondeurIndigoModel extends AbstractAgrosystModel<RefSolProfondeurIndigo> implements ExportModel<RefSolProfondeurIndigo> {

    public RefSolProfondeurIndigoModel() {
        super(';');
        
        newMandatoryColumn("Classe de profondeur INDIGO", RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO);
        newMandatoryColumn("Profondeur", RefSolProfondeurIndigo.PROPERTY_PROFONDEUR);
        newMandatoryColumn("libelle classe", RefSolProfondeurIndigo.PROPERTY_LIBELLE_CLASSE);
        newMandatoryColumn("Profondeur par défaut (cm)", RefSolProfondeurIndigo.PROPERTY_PROFONDEUR_PAR_DEFAUT, INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("source", RefSolProfondeurIndigo.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefSolProfondeurIndigo, Object>> getColumnsForExport() {
        ModelBuilder<RefSolProfondeurIndigo> modelBuilder = new ModelBuilder<RefSolProfondeurIndigo>();
        modelBuilder.newColumnForExport("Classe de profondeur INDIGO", RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO);
        modelBuilder.newColumnForExport("Profondeur", RefSolProfondeurIndigo.PROPERTY_PROFONDEUR);
        modelBuilder.newColumnForExport("libelle classe", RefSolProfondeurIndigo.PROPERTY_LIBELLE_CLASSE);
        modelBuilder.newColumnForExport("Profondeur par défaut (cm)", RefSolProfondeurIndigo.PROPERTY_PROFONDEUR_PAR_DEFAUT, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("source", RefSolProfondeurIndigo.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefSolProfondeurIndigo newEmptyInstance() {
        return new RefSolProfondeurIndigoImpl();
    }
}
