package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefSolCaracteristiqueIndigoModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefSolCaracteristiqueIndigoModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigoImpl;

/**
 * Modele d'import du référentiel sol texture GEPPA:
 * 
 * <ul>
 * <li>abbreviation INDIGO
 * <li>classe INDIGO
 * <li>Classe de profondeur INDIGO
 * <li>Réserve Utile (mm)
 * <li>Source
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class RefSolCaracteristiqueIndigoModel extends AbstractAgrosystModel<RefSolCaracteristiqueIndigo> implements ExportModel<RefSolCaracteristiqueIndigo> {

    public RefSolCaracteristiqueIndigoModel() {
        super(';');
        
        newMandatoryColumn("abbreviation INDIGO", RefSolCaracteristiqueIndigo.PROPERTY_ABBREVIATION__INDIGO);
        newMandatoryColumn("classe INDIGO", RefSolCaracteristiqueIndigo.PROPERTY_CLASSE__INDIGO);
        newMandatoryColumn("Classe de profondeur INDIGO", RefSolCaracteristiqueIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO);
        newMandatoryColumn("Réserve Utile (mm)", RefSolCaracteristiqueIndigo.PROPERTY_RESERVE_UTILE, INT_PARSER);
        newMandatoryColumn("Source", RefSolCaracteristiqueIndigo.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefSolCaracteristiqueIndigo, Object>> getColumnsForExport() {
        ModelBuilder<RefSolCaracteristiqueIndigo> modelBuilder = new ModelBuilder<RefSolCaracteristiqueIndigo>();
        modelBuilder.newColumnForExport("abbreviation INDIGO", RefSolCaracteristiqueIndigo.PROPERTY_ABBREVIATION__INDIGO);
        modelBuilder.newColumnForExport("classe INDIGO", RefSolCaracteristiqueIndigo.PROPERTY_CLASSE__INDIGO);
        modelBuilder.newColumnForExport("Classe de profondeur INDIGO", RefSolCaracteristiqueIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO);
        modelBuilder.newColumnForExport("Réserve Utile (mm)", RefSolCaracteristiqueIndigo.PROPERTY_RESERVE_UTILE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefSolCaracteristiqueIndigo.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefSolCaracteristiqueIndigo newEmptyInstance() {
        return new RefSolCaracteristiqueIndigoImpl();
    }
}
