package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefSolArvalisModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefSolArvalisModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalisImpl;

/**
 * Sol arvalis import model
 * 
 * Columns:
 * <pre>
 * id_type_sol character varying(20) NOT NULL,;  sol_nom text,;  sol_calcaire text,;
 * sol_hydromorphie text,;  sol_pierrosite text,;  sol_profondeur text,;  sol_texture text,;
 * sol_region text,;Source
 * </pre>
 * 
 * @author Eric Chatellier
 */
public class RefSolArvalisModel extends AbstractAgrosystModel<RefSolArvalis> implements ExportModel<RefSolArvalis> {

    public RefSolArvalisModel() {
        super(';');

        newMandatoryColumn("id_type_sol character varying(20) NOT NULL,", RefSolArvalis.PROPERTY_ID_TYPE_SOL);
        newMandatoryColumn("sol_nom text,", RefSolArvalis.PROPERTY_SOL_NOM);
        newMandatoryColumn("sol_calcaire text,", RefSolArvalis.PROPERTY_SOL_CALCAIRE);
        newMandatoryColumn("sol_hydromorphie text,", RefSolArvalis.PROPERTY_SOL_HYDROMORPHIE);
        newMandatoryColumn("sol_pierrosite text,", RefSolArvalis.PROPERTY_SOL_PIERROSITE);
        newMandatoryColumn("sol_profondeur text,", RefSolArvalis.PROPERTY_SOL_PROFONDEUR);
        newMandatoryColumn("sol_texture text,", RefSolArvalis.PROPERTY_SOL_TEXTURE);
        newMandatoryColumn("sol_region text,", RefSolArvalis.PROPERTY_SOL_REGION);
        newMandatoryColumn("Source", RefSolArvalis.PROPERTY_SOURCE);
    }

    @Override
    public RefSolArvalis newEmptyInstance() {
        return new RefSolArvalisImpl();
    }

    @Override
    public Iterable<ExportableColumn<RefSolArvalis, Object>> getColumnsForExport() {
        ModelBuilder<RefSolArvalis> modelBuilder = new ModelBuilder<RefSolArvalis>();
        modelBuilder.newColumnForExport("id_type_sol character varying(20) NOT NULL,", RefSolArvalis.PROPERTY_ID_TYPE_SOL);
        modelBuilder.newColumnForExport("sol_nom text,", RefSolArvalis.PROPERTY_SOL_NOM);                                  
        modelBuilder.newColumnForExport("sol_calcaire text,", RefSolArvalis.PROPERTY_SOL_CALCAIRE);                        
        modelBuilder.newColumnForExport("sol_hydromorphie text,", RefSolArvalis.PROPERTY_SOL_HYDROMORPHIE);                
        modelBuilder.newColumnForExport("sol_pierrosite text,", RefSolArvalis.PROPERTY_SOL_PIERROSITE);                    
        modelBuilder.newColumnForExport("sol_profondeur text,", RefSolArvalis.PROPERTY_SOL_PROFONDEUR);                    
        modelBuilder.newColumnForExport("sol_texture text,", RefSolArvalis.PROPERTY_SOL_TEXTURE);                          
        modelBuilder.newColumnForExport("sol_region text,", RefSolArvalis.PROPERTY_SOL_REGION);                            
        modelBuilder.newColumnForExport("Source", RefSolArvalis.PROPERTY_SOURCE);                                          
        return (Iterable) modelBuilder.getColumnsForExport();
    }

}
