package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefSaActaIphyModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefSaActaIphyModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefSaActaIphy;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphyImpl;

/**
 * Référentiel SA_ACTA_IPHY.
 * 
 * nom_SA_ACTA;nom_SA_IPHY
 */
public class RefSaActaIphyModel extends AbstractAgrosystModel<RefSaActaIphy> implements ExportModel<RefSaActaIphy> {

    public RefSaActaIphyModel() {
        super(';');

        newMandatoryColumn("nom_SA_ACTA", RefSaActaIphy.PROPERTY_NOM_SA_ACTA);
        newMandatoryColumn("nom_SA_IPHY", RefSaActaIphy.PROPERTY_NOM_SA_IPHY);
        newIgnoredColumn("Commentaires (NMJ_14/01/2014)");
    }

    @Override
    public Iterable<ExportableColumn<RefSaActaIphy, Object>> getColumnsForExport() {
        ModelBuilder<RefSaActaIphy> modelBuilder = new ModelBuilder<RefSaActaIphy>();
        modelBuilder.newColumnForExport("nom_SA_ACTA", RefSaActaIphy.PROPERTY_NOM_SA_ACTA);
        modelBuilder.newColumnForExport("nom_SA_IPHY", RefSaActaIphy.PROPERTY_NOM_SA_IPHY);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefSaActaIphy newEmptyInstance() {
        return new RefSaActaIphyImpl();
    }
}
