package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefPhytoSubstanceActiveIphyModel.java 3263 2014-02-17 10:14:51Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefPhytoSubstanceActiveIphyModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphy;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphyImpl;

/**
 * Référentiel Acta substance active.
 * 
 * Nom SA;Coefficient d'adsoption KOC;Demi-vie (DT50) (jour);Constante Henry (KH) (sans unité);DJA (mg/kg/j);Aquatox (mg/L);Presion vapeur (Pa);Solubilité (mg/L);Source
 *
 */
public class RefPhytoSubstanceActiveIphyModel extends AbstractAgrosystModel<RefPhytoSubstanceActiveIphy> implements ExportModel<RefPhytoSubstanceActiveIphy> {

    public RefPhytoSubstanceActiveIphyModel() {
        super(';');

        newMandatoryColumn("Nom SA", RefPhytoSubstanceActiveIphy.PROPERTY_NOM_SA);
        newMandatoryColumn("Coefficient d'adsoption KOC", RefPhytoSubstanceActiveIphy.PROPERTY_KOC, DOUBLE_PARSER);
        newMandatoryColumn("Demi-vie (DT50) (jour)", RefPhytoSubstanceActiveIphy.PROPERTY_DT50, DOUBLE_PARSER);
        newMandatoryColumn("Constante Henry (KH) (sans unité)", RefPhytoSubstanceActiveIphy.PROPERTY_KH, DOUBLE_PARSER);
        newMandatoryColumn("DJA (mg/kg/j)", RefPhytoSubstanceActiveIphy.PROPERTY_DJA, DOUBLE_PARSER);
        newMandatoryColumn("Aquatox (mg/L)", RefPhytoSubstanceActiveIphy.PROPERTY_AQUATOX, DOUBLE_PARSER);
        newMandatoryColumn("Presion vapeur (Pa)", RefPhytoSubstanceActiveIphy.PROPERTY_PRESSION_VAPEUR, DOUBLE_PARSER);
        newMandatoryColumn("Solubilité (mg/L)", RefPhytoSubstanceActiveIphy.PROPERTY_SOLUBILITE, DOUBLE_PARSER);
        newMandatoryColumn("Source", RefPhytoSubstanceActiveIphy.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefPhytoSubstanceActiveIphy, Object>> getColumnsForExport() {
        ModelBuilder<RefPhytoSubstanceActiveIphy> modelBuilder = new ModelBuilder<RefPhytoSubstanceActiveIphy>();
        modelBuilder.newColumnForExport("Nom SA", RefPhytoSubstanceActiveIphy.PROPERTY_NOM_SA);
        modelBuilder.newColumnForExport("Coefficient d'adsoption KOC", RefPhytoSubstanceActiveIphy.PROPERTY_KOC, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Demi-vie (DT50) (jour)", RefPhytoSubstanceActiveIphy.PROPERTY_DT50, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Constante Henry (KH) (sans unité)", RefPhytoSubstanceActiveIphy.PROPERTY_KH, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("DJA (mg/kg/j)", RefPhytoSubstanceActiveIphy.PROPERTY_DJA, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Aquatox (mg/L)", RefPhytoSubstanceActiveIphy.PROPERTY_AQUATOX, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Presion vapeur (Pa)", RefPhytoSubstanceActiveIphy.PROPERTY_PRESSION_VAPEUR, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Solubilité (mg/L)", RefPhytoSubstanceActiveIphy.PROPERTY_SOLUBILITE, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefPhytoSubstanceActiveIphy.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefPhytoSubstanceActiveIphy newEmptyInstance() {
        return new RefPhytoSubstanceActiveIphyImpl();
    }
}
