package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefParcelleZonageEdiModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefParcelleZonageEdiModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDIImpl;

/**
 * Modele d'import du référentiel parcelle zonage EDI
 * 
 * <ul>
 * <li>code engagement parcelle
 * <li>libelle engagement parcelle
 * <li>source
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class RefParcelleZonageEdiModel extends AbstractAgrosystModel<RefParcelleZonageEDI> implements ExportModel<RefParcelleZonageEDI> {

    public RefParcelleZonageEdiModel() {
        super(';');
        
        newMandatoryColumn("code engagement parcelle", RefParcelleZonageEDI.PROPERTY_CODE_ENGAGEMENT_PARCELLE);
        newMandatoryColumn("libelle engagement parcelle", RefParcelleZonageEDI.PROPERTY_LIBELLE_ENGAGEMENT_PARCELLE);
        newMandatoryColumn("source", RefParcelleZonageEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefParcelleZonageEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefParcelleZonageEDI> modelBuilder = new ModelBuilder<RefParcelleZonageEDI>();
        modelBuilder.newColumnForExport("code engagement parcelle", RefParcelleZonageEDI.PROPERTY_CODE_ENGAGEMENT_PARCELLE);
        modelBuilder.newColumnForExport("libelle engagement parcelle", RefParcelleZonageEDI.PROPERTY_LIBELLE_ENGAGEMENT_PARCELLE);
        modelBuilder.newColumnForExport("source", RefParcelleZonageEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefParcelleZonageEDI newEmptyInstance() {
        return new RefParcelleZonageEDIImpl();
    }
}
