package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefOrientationEdiModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefOrientationEdiModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDIImpl;

public class RefOrientationEdiModel extends AbstractAgrosystModel<RefOrientationEDI> implements ExportModel<RefOrientationEDI> {

    public RefOrientationEdiModel() {
        super(';');
        newMandatoryColumn("repository_id", RefOrientationEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefOrientationEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefOrientationEDI.PROPERTY_REFERENCE_PARAM);
        newMandatoryColumn("reference_code", RefOrientationEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefOrientationEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefOrientationEDI.PROPERTY_SOURCE);
    }

    @Override
    public RefOrientationEDI newEmptyInstance() {
        RefOrientationEDI result = new RefOrientationEDIImpl();
        return result;
    }

    @Override
    public Iterable<ExportableColumn<RefOrientationEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefOrientationEDI> modelBuilder = new ModelBuilder<RefOrientationEDI>();
        modelBuilder.newColumnForExport("repository_id", RefOrientationEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefOrientationEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefOrientationEDI.PROPERTY_REFERENCE_PARAM);
        modelBuilder.newColumnForExport("reference_code", RefOrientationEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefOrientationEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefOrientationEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
