package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefOTEXModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefOTEXModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOTEXImpl;

/**
 * @author cosse
 *
 */
public class RefOTEXModel extends AbstractAgrosystModel<RefOTEX> implements ExportModel<RefOTEX> {

    public RefOTEXModel() {
        super(';');
        newMandatoryColumn("Code OTEX 18 postes", RefOTEX.PROPERTY_CODE__OTEX_18_POSTES, INT_PARSER);
        newMandatoryColumn("libelle OTEX 18 postes", RefOTEX.PROPERTY_LIBELLE__OTEX_18_POSTES);
        newMandatoryColumn("code OTEX 70 postes", RefOTEX.PROPERTY_CODE__OTEX_70_POSTES, INT_PARSER);
        newMandatoryColumn("libelle OTEX 70 postes", RefOTEX.PROPERTY_LIBELLE__OTEX_70_POSTES);
        newMandatoryColumn("Source", RefOTEX.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefOTEX, Object>> getColumnsForExport() {
        ModelBuilder<RefOTEX> modelBuilder = new ModelBuilder<RefOTEX>();
        modelBuilder.newColumnForExport("Code OTEX 18 postes", RefOTEX.PROPERTY_CODE__OTEX_18_POSTES, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("libelle OTEX 18 postes", RefOTEX.PROPERTY_LIBELLE__OTEX_18_POSTES);
        modelBuilder.newColumnForExport("code OTEX 70 postes", RefOTEX.PROPERTY_CODE__OTEX_70_POSTES, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("libelle OTEX 70 postes", RefOTEX.PROPERTY_LIBELLE__OTEX_70_POSTES);
        modelBuilder.newColumnForExport("Source", RefOTEX.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefOTEX newEmptyInstance() {
        RefOTEXImpl result = new RefOTEXImpl();
        return result;
    }
}
