package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefNuisibleEDIModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefNuisibleEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDIImpl;

/**
 * Modele d'import du référentiel NuisiblesEDI.
 * 
 * <ul>
 * <li>repository_id
 * <li>reference_id
 * <li>reference_param
 * <li>reference_code
 * <li>reference_label
 * <li>source
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class RefNuisibleEDIModel extends AbstractAgrosystModel<RefNuisibleEDI> implements ExportModel<RefNuisibleEDI> {

    public RefNuisibleEDIModel() {
        super(';');
        
        newMandatoryColumn("repository_id", RefNuisibleEDI.PROPERTY_REPOSITORY_ID, INT_PARSER);
        newMandatoryColumn("reference_id", RefNuisibleEDI.PROPERTY_REFERENCE_ID, INT_PARSER);
        newMandatoryColumn("reference_param", RefNuisibleEDI.PROPERTY_REFERENCE_PARAM, AGROSYST_BIO_AGRESSOR_TYPE_PARSER);
        newMandatoryColumn("reference_code", RefNuisibleEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefNuisibleEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefNuisibleEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefNuisibleEDI, Object>> getColumnsForExport() {
        ModelBuilder<RefNuisibleEDI> modelBuilder = new ModelBuilder<RefNuisibleEDI>();
        modelBuilder.newColumnForExport("repository_id", RefNuisibleEDI.PROPERTY_REPOSITORY_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_id", RefNuisibleEDI.PROPERTY_REFERENCE_ID, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("reference_param", RefNuisibleEDI.PROPERTY_REFERENCE_PARAM, AGROSYST_BIO_AGRESSOR_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("reference_code", RefNuisibleEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefNuisibleEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefNuisibleEDI.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefNuisibleEDI newEmptyInstance() {
        return new RefNuisibleEDIImpl();
    }
}
