package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefNrjSemenceModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefNrjSemenceModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefNrjSemence;
import fr.inra.agrosyst.api.entities.referential.RefNrjSemenceImpl;

/**
 * code culture;libelle culture;NRJ (MJ/kg);source
 * 
 * @author Eric Chatellier
 */
public class RefNrjSemenceModel extends AbstractAgrosystModel<RefNrjSemence> implements ExportModel<RefNrjSemence> {

    public RefNrjSemenceModel() {
        super(';');
        
        newMandatoryColumn("code culture", RefNrjSemence.PROPERTY_CODE_CULTURE);
        newMandatoryColumn("libelle culture", RefNrjSemence.PROPERTY_LIBELLE_CULTURE);
        newMandatoryColumn("NRJ (MJ/kg)", RefNrjSemence.PROPERTY_NRJ, DOUBLE_PARSER);
        newMandatoryColumn("source", RefNrjSemence.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefNrjSemence, Object>> getColumnsForExport() {
        ModelBuilder<RefNrjSemence> modelBuilder = new ModelBuilder<RefNrjSemence>();
        modelBuilder.newColumnForExport("Intitulé", RefNrjSemence.PROPERTY_CODE_CULTURE);
        modelBuilder.newColumnForExport("libelle culture", RefNrjSemence.PROPERTY_LIBELLE_CULTURE);
        modelBuilder.newColumnForExport("NRJ (MJ/kg)", RefNrjSemence.PROPERTY_NRJ, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("source", RefNrjSemence.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefNrjSemence newEmptyInstance() {
        return new RefNrjSemenceImpl();
    }
}
