package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefNrjPhytoModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefNrjPhytoModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefNrjPhyto;
import fr.inra.agrosyst.api.entities.referential.RefNrjPhytoImpl;

/**
 * Intitulé;NRJ (MJ/kg);Source
 * 
 * @author Eric Chatellier
 */
public class RefNrjPhytoModel extends AbstractAgrosystModel<RefNrjPhyto> implements ExportModel<RefNrjPhyto> {

    public RefNrjPhytoModel() {
        super(';');
        
        newMandatoryColumn("Intitulé", RefNrjPhyto.PROPERTY_INTITULE);
        newMandatoryColumn("NRJ (MJ/kg)", RefNrjPhyto.PROPERTY_NRJ, DOUBLE_PARSER);
        newMandatoryColumn("Source", RefNrjPhyto.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefNrjPhyto, Object>> getColumnsForExport() {
        ModelBuilder<RefNrjPhyto> modelBuilder = new ModelBuilder<RefNrjPhyto>();
        modelBuilder.newColumnForExport("Intitulé", RefNrjPhyto.PROPERTY_INTITULE);
        modelBuilder.newColumnForExport("NRJ (MJ/kg)", RefNrjPhyto.PROPERTY_NRJ, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefNrjPhyto.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefNrjPhyto newEmptyInstance() {
        return new RefNrjPhytoImpl();
    }
}
