package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefNrjGesOutilModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefNrjGesOutilModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutil;
import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutilImpl;

/**
 * Code type de materiel GES'TIM;libelle type de materiel GES'TIM;GES (kq eq-CO2/kg outil);NRJ (MJ/kg outil);source
 * 
 * @author Eric Chatellier
 */
public class RefNrjGesOutilModel extends AbstractAgrosystModel<RefNrjGesOutil> implements ExportModel<RefNrjGesOutil> {

    public RefNrjGesOutilModel() {
        super(';');

        newMandatoryColumn("Code type de materiel GES'TIM", RefNrjGesOutil.PROPERTY_CODE_TYPE_MATERIEL);
        newMandatoryColumn("libelle type de materiel GES'TIM", RefNrjGesOutil.PROPERTY_LIBELLE_TYPE_MATERIEL);
        newMandatoryColumn("GES (kq eq-CO2/kg outil)", RefNrjGesOutil.PROPERTY_GES, DOUBLE_PARSER);
        newMandatoryColumn("NRJ (MJ/kg outil)", RefNrjGesOutil.PROPERTY_NRJ, DOUBLE_PARSER);
        newMandatoryColumn("source", RefNrjGesOutil.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefNrjGesOutil, Object>> getColumnsForExport() {
        ModelBuilder<RefNrjGesOutil> modelBuilder = new ModelBuilder<RefNrjGesOutil>();
        modelBuilder.newColumnForExport("Code type de materiel GES'TIM", RefNrjGesOutil.PROPERTY_CODE_TYPE_MATERIEL);
        modelBuilder.newColumnForExport("libelle type de materiel GES'TIM", RefNrjGesOutil.PROPERTY_LIBELLE_TYPE_MATERIEL);
        modelBuilder.newColumnForExport("GES (kq eq-CO2/kg outil)", RefNrjGesOutil.PROPERTY_GES, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("NRJ (MJ/kg outil)", RefNrjGesOutil.PROPERTY_NRJ, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("source", RefNrjGesOutil.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefNrjGesOutil newEmptyInstance() {
        return new RefNrjGesOutilImpl();
    }
}
