package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefNrjEngraisModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefNrjEngraisModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefNrjEngrais;
import fr.inra.agrosyst.api.entities.referential.RefNrjEngraisImpl;

/**
 * Type d'engrais, NRJ (MJ/kg N), NRJ (MJ/kg P205), NRJ (MJ/kg K2O), Source
 * 
 * @author Eric Chatellier
 */
public class RefNrjEngraisModel extends AbstractAgrosystModel<RefNrjEngrais> implements ExportModel<RefNrjEngrais> {

    public RefNrjEngraisModel() {
        super(';');
        
        newMandatoryColumn("Type d'engrais", RefNrjEngrais.PROPERTY_TYPE_ENGRAIS);
        newMandatoryColumn("NRJ (MJ/kg N)", RefNrjEngrais.PROPERTY_NRJ_N, DOUBLE_PARSER);
        newMandatoryColumn("NRJ (MJ/kg P205)", RefNrjEngrais.PROPERTY_NRJ_P2O5, DOUBLE_PARSER);
        newMandatoryColumn("NRJ (MJ/kg K2O)", RefNrjEngrais.PROPERTY_NRJ_K2O, DOUBLE_PARSER);
        newMandatoryColumn("Source", RefNrjEngrais.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefNrjEngrais, Object>> getColumnsForExport() {
        ModelBuilder<RefNrjEngrais> modelBuilder = new ModelBuilder<RefNrjEngrais>();
        modelBuilder.newColumnForExport("Type d'engrais", RefNrjEngrais.PROPERTY_TYPE_ENGRAIS);
        modelBuilder.newColumnForExport("NRJ (MJ/kg N)", RefNrjEngrais.PROPERTY_NRJ_N, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("NRJ (MJ/kg P205)", RefNrjEngrais.PROPERTY_NRJ_P2O5, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("NRJ (MJ/kg K2O)", RefNrjEngrais.PROPERTY_NRJ_K2O, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefNrjEngrais.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefNrjEngrais newEmptyInstance() {
        return new RefNrjEngraisImpl();
    }
}
