package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefNrjCarburantModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefNrjCarburantModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefNrjCarburant;
import fr.inra.agrosyst.api.entities.referential.RefNrjCarburantImpl;

/**
 * libelle carburant;unité;NRJ (MJ/unite);Source
 * 
 * @author Eric Chatellier
 */
public class RefNrjCarburantModel extends AbstractAgrosystModel<RefNrjCarburant> implements ExportModel<RefNrjCarburant> {

    public RefNrjCarburantModel() {
        super(';');
        
        newMandatoryColumn("libelle carburant", RefNrjCarburant.PROPERTY_LIBELLE_CARBURANT);
        newMandatoryColumn("unité", RefNrjCarburant.PROPERTY_UNITE);
        newMandatoryColumn("NRJ (MJ/unite)", RefNrjCarburant.PROPERTY_NRJ, DOUBLE_PARSER);
        newMandatoryColumn("Source", RefNrjCarburant.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefNrjCarburant, Object>> getColumnsForExport() {
        ModelBuilder<RefNrjCarburant> modelBuilder = new ModelBuilder<RefNrjCarburant>();
        modelBuilder.newColumnForExport("libelle carburant", RefNrjCarburant.PROPERTY_LIBELLE_CARBURANT);
        modelBuilder.newColumnForExport("unité", RefNrjCarburant.PROPERTY_UNITE);
        modelBuilder.newColumnForExport("NRJ (MJ/unite)", RefNrjCarburant.PROPERTY_NRJ, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefNrjCarburant.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefNrjCarburant newEmptyInstance() {
        return new RefNrjCarburantImpl();
    }
}
