package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefMesureModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefMesureModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.ParseException;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefMesureImpl;

/**
 * Data model import for {@link RefMesure}.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class RefMesureModel extends AbstractAgrosystModel<RefMesure> implements ExportModel<RefMesure> {

    protected static final ValueFormatter<MeasurementType> MEASUREMENT_TYPE_FORMATTER = new ValueFormatter<MeasurementType>() {
        @Override
        public String format(MeasurementType value) {
            String result;
            if (value != null) {
                result = value.name().toLowerCase();
            } else {
                result = "";
            }
            return result;
        }
    };

    protected static final ValueParser<MeasurementType> MEASUREMENT_TYPE_PARSER = new ValueParser<MeasurementType>() {
        @Override
        public MeasurementType parse(String value) throws ParseException {
            MeasurementType result = null;
            if (!Strings.isNullOrEmpty(value)) {
                String strValue = StringUtils.stripAccents(value);
                strValue = strValue.replaceAll("\\W", "_"); // non word chars
                strValue = strValue.toUpperCase();
                result = MeasurementType.valueOf(strValue);
            }
            return result;
        }
    };

    protected static final ValueFormatter<VariableType> VARIABLE_TYPE_FORMATTER = new ValueFormatter<VariableType>() {
        @Override
        public String format(VariableType value) {
            String result;
            if (value != null) {
                result = value.name().toLowerCase();
            } else {
                result = "";
            }
            return result;
        }
    };

    protected static final ValueParser<VariableType> VARIABLE_TYPE_PARSER = new ValueParser<VariableType>() {
        @Override
        public VariableType parse(String value) throws ParseException {
            VariableType result = null;
            if (!Strings.isNullOrEmpty(value)) {
                String strValue = StringUtils.stripAccents(value);
                strValue = strValue.replaceAll("\\W", "_"); // non word chars
                strValue = strValue.toUpperCase();
                result = VariableType.valueOf(strValue);
            }
            return result;
        }
    };

    public RefMesureModel() {
        super(';');

        newMandatoryColumn("Catégorie de mesure", RefMesure.PROPERTY_CATEGORIE_DE_MESURE, MEASUREMENT_TYPE_PARSER);
        newMandatoryColumn("Type variable mesurée", RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, VARIABLE_TYPE_PARSER);
        newMandatoryColumn("variable mesurée", RefMesure.PROPERTY_VARIABLE_MESUREE);
        newMandatoryColumn("unité", RefMesure.PROPERTY_UNITE);
        newMandatoryColumn("valeur attendue", RefMesure.PROPERTY_VALEUR_ATTENDUE);
        newMandatoryColumn("Remarque", RefMesure.PROPERTY_REMARQUE);
    }

    @Override
    public RefMesure newEmptyInstance() {
        return new RefMesureImpl();
    }

    @Override
    @SuppressWarnings({ "unchecked", "rawtypes" })
    public Iterable<ExportableColumn<RefMesure, Object>> getColumnsForExport() {
        ModelBuilder<RefMesure> modelBuilder = new ModelBuilder<RefMesure>();
        modelBuilder.newColumnForExport("Catégorie de mesure", RefMesure.PROPERTY_CATEGORIE_DE_MESURE, MEASUREMENT_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("Type variable mesurée", RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, VARIABLE_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("variable mesurée", RefMesure.PROPERTY_VARIABLE_MESUREE);
        modelBuilder.newColumnForExport("unité", RefMesure.PROPERTY_UNITE);
        modelBuilder.newColumnForExport("valeur attendue", RefMesure.PROPERTY_VALEUR_ATTENDUE);
        modelBuilder.newColumnForExport("Remarque", RefMesure.PROPERTY_REMARQUE);

        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
