package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefLocationDto.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefLocationDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Objects;

/**
 * DTO used to create the RefLocation referential.
 *
 * @author cosse
 */
public class RefLocationDto {

    protected String codeInsee;

    protected int region;

    protected String departement;

    protected String codeCommune;

    protected String articleCommune;

    protected String nomCommune;

    protected String codePetiteRegionAgricole;

    protected String nomPetiteRegionAgricole;

    protected String codePostal;

    protected double latitude;

    protected double longitude;

    public String getCodeInsee() {
        return codeInsee;
    }

    public void setCodeInsee(String codeInsee) {
        this.codeInsee = codeInsee;
    }

    public int getRegion() {
        return region;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public String getDepartement() {
        return departement;
    }

    public void setDepartement(String departement) {
        this.departement = departement;
    }

    public String getCodeCommune() {
        return codeCommune;
    }

    public void setCodeCommune(String codeCommune) {
        this.codeCommune = codeCommune;
    }

    public String getArticleCommune() {
        return articleCommune;
    }

    public void setArticleCommune(String articleCommune) {
        this.articleCommune = articleCommune;
    }

    public String getNomCommune() {
        return nomCommune;
    }

    public void setNomCommune(String nomCommune) {
        this.nomCommune = nomCommune;
    }

    public String getCodePetiteRegionAgricole() {
        return codePetiteRegionAgricole;
    }

    public void setCodePetiteRegionAgricole(String codePetiteRegionAgricole) {
        this.codePetiteRegionAgricole = codePetiteRegionAgricole;
    }

    public String getNomPetiteRegionAgricole() {
        return nomPetiteRegionAgricole;
    }

    public void setNomPetiteRegionAgricole(String nomPetiteRegionAgricole) {
        this.nomPetiteRegionAgricole = nomPetiteRegionAgricole;
    }

    public String getCodePostal() {
        return codePostal;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @Override
    public String toString() {
        String result = Objects.toStringHelper(this)
                .add("codeInsee", codeInsee)
                .add("nomCommune", nomCommune)
                .add("codePostal", codePostal)
                .add("codePetiteRegionAgricole", codePetiteRegionAgricole)
                .add("nomPetiteRegionAgricole", nomPetiteRegionAgricole)
                .add("latitude", latitude)
                .add("longitude", longitude)
                .toString();
        return result;
    }
}
