package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefLienCulturesEdiActaModel.java 2803 2014-01-20 21:41:33Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefLienCulturesEdiActaModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActa;
import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActaImpl;

public class RefLienCulturesEdiActaModel extends AbstractAgrosystModel<RefLienCulturesEdiActa> implements ExportModel<RefLienCulturesEdiActa> {

    public RefLienCulturesEdiActaModel() {
        super(';');

        newMandatoryColumn("code_espece_botanique", RefLienCulturesEdiActa.PROPERTY_CODE_ESPECE_BOTANIQUE);
        newMandatoryColumn("libelle_espece_botanique", RefLienCulturesEdiActa.PROPERTY_LIBELLE_ESPECE_BOTANIQUE);
        newMandatoryColumn("code_qualifiant_aee", RefLienCulturesEdiActa.PROPERTY_CODE_QUALIFIANT_AEE);
        newMandatoryColumn("libelle_qualifiant_aee", RefLienCulturesEdiActa.PROPERTY_LIBELLE_QUALIFIANT_AEE);
        newMandatoryColumn("code_type_saisonnier_aee", RefLienCulturesEdiActa.PROPERTY_CODE_TYPE_SAISONNIER_AEE);
        newMandatoryColumn("libelle_type_saisonnier_aee", RefLienCulturesEdiActa.PROPERTY_LIBELLE_TYPE_SAISONNIER_AEE);
        newMandatoryColumn("code_destination_aee", RefLienCulturesEdiActa.PROPERTY_CODE_DESTINATION_AEE);
        newMandatoryColumn("libelle_destination_aee", RefLienCulturesEdiActa.PROPERTY_LIBELLE_DESTINATION_AEE);
        newMandatoryColumn("id_culture", RefLienCulturesEdiActa.PROPERTY_ID_CULTURE, INT_PARSER);
        newMandatoryColumn("nom_culture_ACTA", RefLienCulturesEdiActa.PROPERTY_NOM_CULTURE_ACTA);
        newMandatoryColumn("remarque_culture_ACTA", RefLienCulturesEdiActa.PROPERTY_REMARQUE_CULTURE_ACTA);
    }

    @Override
    public Iterable<ExportableColumn<RefLienCulturesEdiActa, Object>> getColumnsForExport() {
        ModelBuilder<RefLienCulturesEdiActa> modelBuilder = new ModelBuilder<RefLienCulturesEdiActa>();
        modelBuilder.newColumnForExport("code_espece_botanique", RefLienCulturesEdiActa.PROPERTY_CODE_ESPECE_BOTANIQUE);
        modelBuilder.newColumnForExport("libelle_espece_botanique", RefLienCulturesEdiActa.PROPERTY_LIBELLE_ESPECE_BOTANIQUE);
        modelBuilder.newColumnForExport("code_qualifiant_aee", RefLienCulturesEdiActa.PROPERTY_CODE_QUALIFIANT_AEE);
        modelBuilder.newColumnForExport("libelle_qualifiant_aee", RefLienCulturesEdiActa.PROPERTY_LIBELLE_QUALIFIANT_AEE);
        modelBuilder.newColumnForExport("code_type_saisonnier_aee", RefLienCulturesEdiActa.PROPERTY_CODE_TYPE_SAISONNIER_AEE);
        modelBuilder.newColumnForExport("libelle_type_saisonnier_aee", RefLienCulturesEdiActa.PROPERTY_LIBELLE_TYPE_SAISONNIER_AEE);
        modelBuilder.newColumnForExport("code_destination_aee", RefLienCulturesEdiActa.PROPERTY_CODE_DESTINATION_AEE);
        modelBuilder.newColumnForExport("libelle_destination_aee", RefLienCulturesEdiActa.PROPERTY_LIBELLE_DESTINATION_AEE);
        modelBuilder.newColumnForExport("id_culture", RefLienCulturesEdiActa.PROPERTY_ID_CULTURE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("nom_culture_ACTA", RefLienCulturesEdiActa.PROPERTY_NOM_CULTURE_ACTA);
        modelBuilder.newColumnForExport("remarque_culture_ACTA", RefLienCulturesEdiActa.PROPERTY_REMARQUE_CULTURE_ACTA);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
    
    @Override
    public RefLienCulturesEdiActa newEmptyInstance() {
        RefLienCulturesEdiActa result = new RefLienCulturesEdiActaImpl();
        return result;
    }
}
