package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefLegalStatusModel.java 3571 2014-03-03 15:23:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefLegalStatusModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.ParseException;

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatusImpl;

public class RefLegalStatusModel extends AbstractAgrosystModel<RefLegalStatus> implements ExportModel<RefLegalStatus> {

    /**
     * String to integer converter.
     */
    protected static final ValueParser<Boolean> INT_TO_BOOLEAN_PARSER = new ValueParser<Boolean>() {
        @Override
        public Boolean parse(String value) throws ParseException {
            boolean result = "1".equals(value);
            return result;
        }
    };

    public RefLegalStatusModel() {
        super(';');

        newMandatoryColumn("code INSEE", RefLegalStatus.PROPERTY_CODE__INSEE, INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("libelle INSEE", RefLegalStatus.PROPERTY_LIBELLE__INSEE);
        newMandatoryColumn("Société", RefLegalStatus.PROPERTY_SOCIETE, INT_TO_BOOLEAN_PARSER);
        newMandatoryColumn("Source", RefLegalStatus.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefLegalStatus, Object>> getColumnsForExport() {
        ModelBuilder<RefLegalStatus> modelBuilder = new ModelBuilder<RefLegalStatus>();
        modelBuilder.newColumnForExport("code INSEE", RefLegalStatus.PROPERTY_CODE__INSEE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("libelle INSEE", RefLegalStatus.PROPERTY_LIBELLE__INSEE);
        modelBuilder.newColumnForExport("Société", RefLegalStatus.PROPERTY_SOCIETE, new ValueFormatter<Boolean>() {
            @Override
            public String format(Boolean value) {
                if (value.booleanValue()) {
                    return "1";
                } else {
                    return "0";
                }
            }
        });
        modelBuilder.newColumnForExport("Source", RefLegalStatus.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefLegalStatus newEmptyInstance() {
        return new RefLegalStatusImpl();
    }

}
