package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefInterventionAgrosystTravailEDIModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefInterventionAgrosystTravailEDIModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDIImpl;

/**
 * @author David Cossé
 */
public class RefInterventionAgrosystTravailEDIModel  extends AbstractAgrosystModel<RefInterventionAgrosystTravailEDI> implements ExportModel<RefInterventionAgrosystTravailEDI> {

    public RefInterventionAgrosystTravailEDIModel() {
        super(';');

        newMandatoryColumn("Intervention agrosyst", RefInterventionAgrosystTravailEDI.PROPERTY_INTERVENTION_AGROSYST, AGROSYST_INTERVENTION_TYPE_PARSER);
        newMandatoryColumn("reference_code", RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE);
        newMandatoryColumn("reference_label", RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_LABEL);
        newMandatoryColumn("source", RefInterventionAgrosystTravailEDI.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefInterventionAgrosystTravailEDI, Object>> getColumnsForExport() {

        ModelBuilder<RefInterventionAgrosystTravailEDI> modelBuilder = new ModelBuilder<RefInterventionAgrosystTravailEDI>();
        modelBuilder.newColumnForExport("Intervention agrosyst", RefInterventionAgrosystTravailEDI.PROPERTY_INTERVENTION_AGROSYST, AGROSYST_INTERVENTION_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("reference_code", RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE);
        modelBuilder.newColumnForExport("reference_label", RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_LABEL);
        modelBuilder.newColumnForExport("source", RefInterventionAgrosystTravailEDI.PROPERTY_SOURCE);
        Iterable result = modelBuilder.getColumnsForExport();
        return result;
    }

    @Override
    public RefInterventionAgrosystTravailEDI newEmptyInstance() {
        return new RefInterventionAgrosystTravailEDIImpl();
    }

}
