package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefGesSemenceModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefGesSemenceModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefGesSemence;
import fr.inra.agrosyst.api.entities.referential.RefGesSemenceImpl;

/**
 * code culture;libelle culture;GES (kq eq-CO2/kg);source
 * 
 * @author Eric Chatellier
 */
public class RefGesSemenceModel extends AbstractAgrosystModel<RefGesSemence> implements ExportModel<RefGesSemence> {

    public RefGesSemenceModel() {
        super(';');
        
        newMandatoryColumn("code culture", RefGesSemence.PROPERTY_CODE_CULTURE);
        newMandatoryColumn("libelle culture", RefGesSemence.PROPERTY_LIBELLE_CULTURE);
        newMandatoryColumn("GES (kq eq-CO2/kg)", RefGesSemence.PROPERTY_GES, DOUBLE_PARSER);
        newMandatoryColumn("source", RefGesSemence.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefGesSemence, Object>> getColumnsForExport() {
        ModelBuilder<RefGesSemence> modelBuilder = new ModelBuilder<RefGesSemence>();
        modelBuilder.newColumnForExport("Intitulé", RefGesSemence.PROPERTY_CODE_CULTURE);
        modelBuilder.newColumnForExport("libelle culture", RefGesSemence.PROPERTY_LIBELLE_CULTURE);
        modelBuilder.newColumnForExport("GES (kq eq-CO2/kg)", RefGesSemence.PROPERTY_GES, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("source", RefGesSemence.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefGesSemence newEmptyInstance() {
        return new RefGesSemenceImpl();
    }
}
