package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefGesPhytoModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefGesPhytoModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefGesPhyto;
import fr.inra.agrosyst.api.entities.referential.RefGesPhytoImpl;

/**
 * Intitulé;GES (kq eq-CO2/kg);Source
 * 
 * @author Eric Chatellier
 */
public class RefGesPhytoModel extends AbstractAgrosystModel<RefGesPhyto> implements ExportModel<RefGesPhyto> {

    public RefGesPhytoModel() {
        super(';');
        
        newMandatoryColumn("Intitulé", RefGesPhyto.PROPERTY_INTITULE);
        newMandatoryColumn("GES (kq eq-CO2/kg)", RefGesPhyto.PROPERTY_GES, DOUBLE_PARSER);
        newMandatoryColumn("Source", RefGesPhyto.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefGesPhyto, Object>> getColumnsForExport() {
        ModelBuilder<RefGesPhyto> modelBuilder = new ModelBuilder<RefGesPhyto>();
        modelBuilder.newColumnForExport("Intitulé", RefGesPhyto.PROPERTY_INTITULE);
        modelBuilder.newColumnForExport("GES (kq eq-CO2/kg)", RefGesPhyto.PROPERTY_GES, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefGesPhyto.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefGesPhyto newEmptyInstance() {
        return new RefGesPhytoImpl();
    }
}
