package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefGesEngraisModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefGesEngraisModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefGesEngrais;
import fr.inra.agrosyst.api.entities.referential.RefGesEngraisImpl;

/**
 * Type d'engrais, GES indirects FE (i) (kq eq-CO2/kg N), GES indirects FE (i) (kq eq-CO2/kg P205), GES indirects FE (i) (kq eq-CO2/kg K2O), Source
 * 
 * @author Eric Chatellier
 */
public class RefGesEngraisModel extends AbstractAgrosystModel<RefGesEngrais> implements ExportModel<RefGesEngrais> {

    public RefGesEngraisModel() {
        super(';');
        
        newMandatoryColumn("Type d'engrais", RefGesEngrais.PROPERTY_TYPE_ENGRAIS);
        newMandatoryColumn("GES indirects FE (i) (kq eq-CO2/kg N)", RefGesEngrais.PROPERTY_GES_N, DOUBLE_PARSER);
        newMandatoryColumn("GES indirects FE (i) (kq eq-CO2/kg P205)", RefGesEngrais.PROPERTY_GES_P2O5, DOUBLE_PARSER);
        newMandatoryColumn("GES indirects FE (i) (kq eq-CO2/kg K2O)", RefGesEngrais.PROPERTY_GES_K2O, DOUBLE_PARSER);
        newMandatoryColumn("Source", RefGesEngrais.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefGesEngrais, Object>> getColumnsForExport() {
        ModelBuilder<RefGesEngrais> modelBuilder = new ModelBuilder<RefGesEngrais>();
        modelBuilder.newColumnForExport("Type d'engrais", RefGesEngrais.PROPERTY_TYPE_ENGRAIS);
        modelBuilder.newColumnForExport("GES indirects FE (i) (kq eq-CO2/kg N)", RefGesEngrais.PROPERTY_GES_N, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("GES indirects FE (i) (kq eq-CO2/kg P205)", RefGesEngrais.PROPERTY_GES_P2O5, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("GES indirects FE (i) (kq eq-CO2/kg K2O)", RefGesEngrais.PROPERTY_GES_K2O, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefGesEngrais.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefGesEngrais newEmptyInstance() {
        return new RefGesEngraisImpl();
    }
}
