package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefGesCarburantModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefGesCarburantModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefGesCarburant;
import fr.inra.agrosyst.api.entities.referential.RefGesCarburantImpl;

/**
 * libelle carburant;unité;GES (kq eq-CO2/unite);Source
 * 
 * @author Eric Chatellier
 */
public class RefGesCarburantModel extends AbstractAgrosystModel<RefGesCarburant> implements ExportModel<RefGesCarburant> {

    public RefGesCarburantModel() {
        super(';');
        
        newMandatoryColumn("libelle carburant", RefGesCarburant.PROPERTY_LIBELLE_CARBURANT);
        newMandatoryColumn("unité", RefGesCarburant.PROPERTY_UNITE);
        newMandatoryColumn("GES (kq eq-CO2/unite)", RefGesCarburant.PROPERTY_GES, DOUBLE_PARSER);
        newMandatoryColumn("Source", RefGesCarburant.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefGesCarburant, Object>> getColumnsForExport() {
        ModelBuilder<RefGesCarburant> modelBuilder = new ModelBuilder<RefGesCarburant>();
        modelBuilder.newColumnForExport("libelle carburant", RefGesCarburant.PROPERTY_LIBELLE_CARBURANT);
        modelBuilder.newColumnForExport("unité", RefGesCarburant.PROPERTY_UNITE);
        modelBuilder.newColumnForExport("GES (kq eq-CO2/unite)", RefGesCarburant.PROPERTY_GES, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefGesCarburant.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefGesCarburant newEmptyInstance() {
        return new RefGesCarburantImpl();
    }
}
