package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefFertiOrgaModel.java 2810 2014-01-21 13:34:23Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefFertiOrgaModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrgaImpl;

/**
 * @author David Cossé
 */
public class RefFertiOrgaModel extends AbstractAgrosystModel<RefFertiOrga> implements ExportModel<RefFertiOrga> {

    public RefFertiOrgaModel() {
        super(';');

        newMandatoryColumn("idtypeeffluent (PK)", RefFertiOrga.PROPERTY_IDTYPEEFFLUENT);
        newMandatoryColumn("libelle", RefFertiOrga.PROPERTY_LIBELLE);
        newMandatoryColumn("Teneur_Ferti_Orga_N_total", RefFertiOrga.PROPERTY_TENEUR__FERTI__ORGA__N_TOTAL, DOUBLE_PARSER);
        newMandatoryColumn("Teneur_Ferti_Orga_P", RefFertiOrga.PROPERTY_TENEUR__FERTI__ORGA__P, DOUBLE_PARSER);
        newMandatoryColumn("Teneur_Ferti_Orga_K", RefFertiOrga.PROPERTY_TENEUR__FERTI__ORGA__K, DOUBLE_PARSER);
        newMandatoryColumn("Unité_teneur_ferti_orga",RefFertiOrga.PROPERTY_UNITE_TENEUR_FERTI_ORGA,  AGROSYST_FERTI_ORGA_UNIT_PARSER);
        newMandatoryColumn("source", RefFertiOrga.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefFertiOrga, Object>> getColumnsForExport() {
        ModelBuilder<RefFertiOrga> modelBuilder = new ModelBuilder<RefFertiOrga>();
        modelBuilder.newColumnForExport("idtypeeffluent (PK)", RefFertiOrga.PROPERTY_IDTYPEEFFLUENT);
        modelBuilder.newColumnForExport("libelle", RefFertiOrga.PROPERTY_LIBELLE);
        modelBuilder.newColumnForExport("Teneur_Ferti_Orga_N_total", RefFertiOrga.PROPERTY_TENEUR__FERTI__ORGA__N_TOTAL, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Teneur_Ferti_Orga_P", RefFertiOrga.PROPERTY_TENEUR__FERTI__ORGA__P, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Teneur_Ferti_Orga_K", RefFertiOrga.PROPERTY_TENEUR__FERTI__ORGA__K, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Unité_teneur_ferti_orga", RefFertiOrga.PROPERTY_UNITE_TENEUR_FERTI_ORGA ,AGROSYST_FERTI_ORGA_UNIT_FORMATTER);
        modelBuilder.newColumnForExport("source", RefFertiOrga.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefFertiOrga newEmptyInstance() {
        return new RefFertiOrgaImpl();
    }
}
