package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefFertiMinUNIFAModel.java 4394 2014-10-06 15:14:46Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefFertiMinUNIFAModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFAImpl;

/**
 * @author David Cossé
 */
public class RefFertiMinUNIFAModel extends AbstractAgrosystModel<RefFertiMinUNIFA> implements ExportModel<RefFertiMinUNIFA> {

    public RefFertiMinUNIFAModel() {
        super(';');

        newMandatoryColumn("CATEG", RefFertiMinUNIFA.PROPERTY_CATEG, INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("Type_produit", RefFertiMinUNIFA.PROPERTY_TYPE_PRODUIT);
        newMandatoryColumn("CODEPROD", RefFertiMinUNIFA.PROPERTY_CODEPROD);
        newMandatoryColumn("FORME", RefFertiMinUNIFA.PROPERTY_FORME);
        newMandatoryColumn("N (% poids)", RefFertiMinUNIFA.PROPERTY_N, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("P2O5 (% poids)", RefFertiMinUNIFA.PROPERTY_P2_O5, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("K2O (% poids)", RefFertiMinUNIFA.PROPERTY_K2_O, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Bore (% poids)", RefFertiMinUNIFA.PROPERTY_BORE, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Calcium (% poids)", RefFertiMinUNIFA.PROPERTY_CALCIUM, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Fer (% poids)", RefFertiMinUNIFA.PROPERTY_FER, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Manganèse (% poids)", RefFertiMinUNIFA.PROPERTY_MANGANESE, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Molybdène (% poids)", RefFertiMinUNIFA.PROPERTY_MOLYBDENE, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("MgO (% poids)", RefFertiMinUNIFA.PROPERTY_MG_O, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Oxyde de Sodium (% poids)", RefFertiMinUNIFA.PROPERTY_OXYDE_DE_SODIUM, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("SO3 (% poids)", RefFertiMinUNIFA.PROPERTY_S_O3, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Cuivre (% poids)", RefFertiMinUNIFA.PROPERTY_CUIVRE, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("Zinc (% poids)", RefFertiMinUNIFA.PROPERTY_ZINC, DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("source", RefFertiMinUNIFA.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefFertiMinUNIFA, Object>> getColumnsForExport() {
        ModelBuilder<RefFertiMinUNIFA> modelBuilder = new ModelBuilder<RefFertiMinUNIFA>();
        modelBuilder.newColumnForExport("CATEG", RefFertiMinUNIFA.PROPERTY_CATEG, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("Type_produit", RefFertiMinUNIFA.PROPERTY_TYPE_PRODUIT);
        modelBuilder.newColumnForExport("CODEPROD", RefFertiMinUNIFA.PROPERTY_CODEPROD);
        modelBuilder.newColumnForExport("FORME", RefFertiMinUNIFA.PROPERTY_FORME);
        modelBuilder.newColumnForExport("N (% poids)", RefFertiMinUNIFA.PROPERTY_N, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("P2O5 (% poids)", RefFertiMinUNIFA.PROPERTY_P2_O5, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("K2O (% poids)", RefFertiMinUNIFA.PROPERTY_K2_O, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Bore (% poids)", RefFertiMinUNIFA.PROPERTY_BORE, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Calcium (% poids)", RefFertiMinUNIFA.PROPERTY_CALCIUM, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Fer (% poids)", RefFertiMinUNIFA.PROPERTY_FER, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Manganèse (% poids)", RefFertiMinUNIFA.PROPERTY_MANGANESE, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Molybdène (% poids)", RefFertiMinUNIFA.PROPERTY_MOLYBDENE, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("MgO (% poids)", RefFertiMinUNIFA.PROPERTY_MG_O, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Oxyde de Sodium (% poids)", RefFertiMinUNIFA.PROPERTY_OXYDE_DE_SODIUM, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("SO3 (% poids)", RefFertiMinUNIFA.PROPERTY_S_O3, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Cuivre (% poids)", RefFertiMinUNIFA.PROPERTY_CUIVRE, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("Zinc (% poids)", RefFertiMinUNIFA.PROPERTY_ZINC, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("source", RefFertiMinUNIFA.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefFertiMinUNIFA newEmptyInstance() {
        return new RefFertiMinUNIFAImpl();
    }
}
