package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefFertiEngraisOrgModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefFertiEngraisOrgModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorgImpl;

/**
 * @author David Cossé
 */
public class RefFertiEngraisOrgModel extends AbstractAgrosystModel<RefFertiEngraisorg> implements ExportModel<RefFertiEngraisorg> {

    public RefFertiEngraisOrgModel() {
        super(';');
        newMandatoryColumn("idengraisorg (PK)", RefFertiEngraisorg.PROPERTY_ID_ENGRAISORG);
        newMandatoryColumn("nom", RefFertiEngraisorg.PROPERTY_NOM);
        newMandatoryColumn("n_total", RefFertiEngraisorg.PROPERTY_N_TOTAL);
        newMandatoryColumn("n _ammoniacal", RefFertiEngraisorg.PROPERTY_N_AMMONIACAL);
        newMandatoryColumn("n_nitrique", RefFertiEngraisorg.PROPERTY_N_NITRIQUE);
        newMandatoryColumn("formep",RefFertiEngraisorg.PROPERTY_FORMEP);
        newMandatoryColumn("teneur_p",RefFertiEngraisorg.PROPERTY_TENEUR_P);
        newMandatoryColumn("teneur_k", RefFertiEngraisorg.PROPERTY_TENEUR_K);
        newMandatoryColumn("idunite (FK)", RefFertiEngraisorg.PROPERTY_ID_UNITE);
        newMandatoryColumn("coef_nrj", RefFertiEngraisorg.PROPERTY_COEF_NRJ);
        newMandatoryColumn("apport_mo", RefFertiEngraisorg.PROPERTY_APPORT_MO);
        newMandatoryColumn("id edi intrant (FK)", RefFertiEngraisorg.PROPERTY_ID_EDI_INTRANT);
        newMandatoryColumn("idtypeeffluent (FK)", RefFertiEngraisorg.PROPERTY_ID_TYPE_EFFLUENT);
        newMandatoryColumn("iduniteadministrative (FK)", RefFertiEngraisorg.PROPERTY_ID_UNITE_ADMINISTRATIVE);
        newMandatoryColumn("source", RefFertiEngraisorg.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefFertiEngraisorg, Object>> getColumnsForExport() {
        ModelBuilder<RefFertiEngraisorg> modelBuilder = new ModelBuilder<RefFertiEngraisorg>();
        modelBuilder.newColumnForExport("idengraisorg (PK)", RefFertiEngraisorg.PROPERTY_ID_ENGRAISORG);
        modelBuilder.newColumnForExport("nom", RefFertiEngraisorg.PROPERTY_NOM);
        modelBuilder.newColumnForExport("n_total", RefFertiEngraisorg.PROPERTY_N_TOTAL);
        modelBuilder.newColumnForExport("n _ammoniacal", RefFertiEngraisorg.PROPERTY_N_AMMONIACAL);
        modelBuilder.newColumnForExport("n_nitrique", RefFertiEngraisorg.PROPERTY_N_NITRIQUE);
        modelBuilder.newColumnForExport("formep",RefFertiEngraisorg.PROPERTY_FORMEP);
        modelBuilder.newColumnForExport("teneur_p",RefFertiEngraisorg.PROPERTY_TENEUR_P);
        modelBuilder.newColumnForExport("teneur_k", RefFertiEngraisorg.PROPERTY_TENEUR_K);
        modelBuilder.newColumnForExport("idunite (FK)", RefFertiEngraisorg.PROPERTY_ID_UNITE);
        modelBuilder.newColumnForExport("coef_nrj", RefFertiEngraisorg.PROPERTY_COEF_NRJ);
        modelBuilder.newColumnForExport("apport_mo", RefFertiEngraisorg.PROPERTY_APPORT_MO);
        modelBuilder.newColumnForExport("id edi intrant (FK)", RefFertiEngraisorg.PROPERTY_ID_EDI_INTRANT);
        modelBuilder.newColumnForExport("idtypeeffluent (FK)", RefFertiEngraisorg.PROPERTY_ID_TYPE_EFFLUENT);
        modelBuilder.newColumnForExport("iduniteadministrative (FK)", RefFertiEngraisorg.PROPERTY_ID_UNITE_ADMINISTRATIVE);
        modelBuilder.newColumnForExport("source", RefFertiEngraisorg.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefFertiEngraisorg newEmptyInstance() {
        return new RefFertiEngraisorgImpl();
    }
}

