package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefEspeceToVarieteModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefEspeceToVarieteModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referential.RefEspeceToVarieteImpl;

public class RefEspeceToVarieteModel extends AbstractAgrosystModel<RefEspeceToVariete> implements ExportModel<RefEspeceToVariete> {

    public RefEspeceToVarieteModel() {
        super(';');
        newIgnoredColumn("nom_bota_edi");
        newIgnoredColumn("nom_bota_autre_referentiel");
        newMandatoryColumn("code_espece_edi", RefEspeceToVariete.PROPERTY_CODE_ESPECE_EDI);
        newMandatoryColumn("code_espece_autre_referentiel1", RefEspeceToVariete.PROPERTY_CODE_ESPECE_AUTRE_REFERENTIEL);
        newMandatoryColumn("referentiel source", RefEspeceToVariete.PROPERTY_REFERENTIEL_SOURCE);
        newMandatoryColumn("source", RefEspeceToVariete.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefEspeceToVariete, Object>> getColumnsForExport() {
        ModelBuilder<RefEspeceToVariete> modelBuilder = new ModelBuilder<RefEspeceToVariete>();
        modelBuilder.newColumnForExport("code_espece_edi", RefEspeceToVariete.PROPERTY_CODE_ESPECE_EDI);
        modelBuilder.newColumnForExport("code_espece_autre_referentiel1", RefEspeceToVariete.PROPERTY_CODE_ESPECE_AUTRE_REFERENTIEL);
        modelBuilder.newColumnForExport("referentiel source", RefEspeceToVariete.PROPERTY_REFERENTIEL_SOURCE);
        modelBuilder.newColumnForExport("source", RefEspeceToVariete.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefEspeceToVariete newEmptyInstance() {
        RefEspeceToVarieteImpl result = new RefEspeceToVarieteImpl();
        return result;
    }

}
