package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefEspeceModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefEspeceModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceImpl;

public class RefEspeceModel extends AbstractAgrosystModel<RefEspece> implements ExportModel<RefEspece> {

    public RefEspeceModel() {
        super(';');

        newIgnoredColumn("Date modification");
        newIgnoredColumn("nouveau code espèce");
        newMandatoryColumn("code catégorie de cultures", RefEspece.PROPERTY_CODE_CATEGORIE_DE_CULTURES);
        newMandatoryColumn("libellé catégorie de cultures", RefEspece.PROPERTY_LIBELLE_CATEGORIE_DE_CULTURES);
        newMandatoryColumn("commentaire", RefEspece.PROPERTY_COMMENTAIRE);
        newMandatoryColumn("code espèce botanique", RefEspece.PROPERTY_CODE_ESPECE_BOTANIQUE);
        newMandatoryColumn("libellé espèce botanique", RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE);
        newMandatoryColumn("code qualifiant AEE", RefEspece.PROPERTY_CODE_QUALIFIANT__AEE);
        newMandatoryColumn("libellé qualifiant AEE", RefEspece.PROPERTY_LIBELLE_QUALIFIANT__AEE);
        newMandatoryColumn("code type saisonnier AEE", RefEspece.PROPERTY_CODE_TYPE_SAISONNIER__AEE);
        newMandatoryColumn("libellé type saisonnier AEE", RefEspece.PROPERTY_LIBELLE_TYPE_SAISONNIER__AEE);
        newMandatoryColumn("code destination AEE", RefEspece.PROPERTY_CODE_DESTINATION__AEE);
        newMandatoryColumn("libellé destination AEE", RefEspece.PROPERTY_LIBELLE_DESTINATION__AEE);
        newMandatoryColumn("code CIPAN AEE", RefEspece.PROPERTY_CODE__CIPAN__AEE);
        newMandatoryColumn("libellé CIPAN AEE", RefEspece.PROPERTY_LIBELLE__CIPAN__AEE);
        newMandatoryColumn("libellé destination BBCH", RefEspece.PROPERTY_LIBELLE_DESTINATION__BBCH);
        newMandatoryColumn("profil vegetatif BBCH", RefEspece.PROPERTY_PROFIL_VEGETATIF__BBCH);
        newMandatoryColumn("commentaires", RefEspece.PROPERTY_COMMENTAIRES);
        newMandatoryColumn("code espèce EPPO", RefEspece.PROPERTY_CODE_ESPECE__EPPO);
        newMandatoryColumn("Genre", RefEspece.PROPERTY_GENRE);
        newMandatoryColumn("Espèce", RefEspece.PROPERTY_ESPECE);
        newMandatoryColumn("code GNIS", RefEspece.PROPERTY_CODE__GNIS);
        newMandatoryColumn("Num groupe GNIS", RefEspece.PROPERTY_NUM_GROUPE__GNIS);
        newMandatoryColumn("nom GNIS", RefEspece.PROPERTY_NOM__GNIS);
        newMandatoryColumn("nom latin GNIS", RefEspece.PROPERTY_NOM_LATIN__GNIS);
        newMandatoryColumn("Source", RefEspece.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefEspece, Object>> getColumnsForExport() {
        ModelBuilder<RefEspece> modelBuilder = new ModelBuilder<RefEspece>();
        modelBuilder.newColumnForExport("code catégorie de cultures", RefEspece.PROPERTY_CODE_CATEGORIE_DE_CULTURES);
        modelBuilder.newColumnForExport("libellé catégorie de cultures", RefEspece.PROPERTY_LIBELLE_CATEGORIE_DE_CULTURES);
        modelBuilder.newColumnForExport("commentaire", RefEspece.PROPERTY_COMMENTAIRE);
        modelBuilder.newColumnForExport("code espèce botanique", RefEspece.PROPERTY_CODE_ESPECE_BOTANIQUE);
        modelBuilder.newColumnForExport("libellé espèce botanique", RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE);
        modelBuilder.newColumnForExport("code qualifiant AEE", RefEspece.PROPERTY_CODE_QUALIFIANT__AEE);
        modelBuilder.newColumnForExport("libellé qualifiant AEE", RefEspece.PROPERTY_LIBELLE_QUALIFIANT__AEE);
        modelBuilder.newColumnForExport("code type saisonnier AEE", RefEspece.PROPERTY_CODE_TYPE_SAISONNIER__AEE);
        modelBuilder.newColumnForExport("libellé type saisonnier AEE", RefEspece.PROPERTY_LIBELLE_TYPE_SAISONNIER__AEE);
        modelBuilder.newColumnForExport("code destination AEE", RefEspece.PROPERTY_CODE_DESTINATION__AEE);
        modelBuilder.newColumnForExport("libellé destination AEE", RefEspece.PROPERTY_LIBELLE_DESTINATION__AEE);
        modelBuilder.newColumnForExport("code CIPAN AEE", RefEspece.PROPERTY_CODE__CIPAN__AEE);
        modelBuilder.newColumnForExport("libellé CIPAN AEE", RefEspece.PROPERTY_LIBELLE__CIPAN__AEE);
        modelBuilder.newColumnForExport("libellé destination BBCH", RefEspece.PROPERTY_LIBELLE_DESTINATION__BBCH);
        modelBuilder.newColumnForExport("profil vegetatif BBCH", RefEspece.PROPERTY_PROFIL_VEGETATIF__BBCH);
        modelBuilder.newColumnForExport("commentaires", RefEspece.PROPERTY_COMMENTAIRES);
        modelBuilder.newColumnForExport("code espèce EPPO", RefEspece.PROPERTY_CODE_ESPECE__EPPO);
        modelBuilder.newColumnForExport("Genre", RefEspece.PROPERTY_GENRE);
        modelBuilder.newColumnForExport("Espèce", RefEspece.PROPERTY_ESPECE);
        modelBuilder.newColumnForExport("code GNIS", RefEspece.PROPERTY_CODE__GNIS);
        modelBuilder.newColumnForExport("Num groupe GNIS", RefEspece.PROPERTY_NUM_GROUPE__GNIS);
        modelBuilder.newColumnForExport("nom GNIS", RefEspece.PROPERTY_NOM__GNIS);
        modelBuilder.newColumnForExport("nom latin GNIS", RefEspece.PROPERTY_NOM_LATIN__GNIS);
        modelBuilder.newColumnForExport("Source", RefEspece.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
    
    @Override
    public RefEspece newEmptyInstance() {
        RefEspeceImpl result = new RefEspeceImpl();
        return result;
    }
}
