package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefElementVoisinageModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefElementVoisinageModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinageImpl;

/**
 * Element de voisinage.
 * 
 * id_ref_infrastructure serial NOT NULL,;  iae_nom text,;  iae_surface_equivalente real,;
 * iae_remarque text,;  p_dt_crea timestamp without time zone DEFAULT now(),;
 * p_dt_maj timestamp without time zone,;  iae_no_ordre integer,;  unite_surface character varying,;Source
 * 
 * @author Eric Chatellier
 */
public class RefElementVoisinageModel extends AbstractAgrosystModel<RefElementVoisinage> implements ExportModel<RefElementVoisinage> {

    // parse les dates de la forme 2010-02-22 11:31:41.145
    protected DateFormat DF = new SimpleDateFormat("yyyy-MM-dd mm:hh:ss.SSS");

    protected ValueParser<Date> P_DATE_PARSER = new ValueParser<Date>() {
        @Override
        public Date parse(String value) throws ParseException {
            Date result = null;
            if (!Strings.isNullOrEmpty(value)) {
                result = DF.parse(value);
            }
            return result;
        }
    };
    
    protected ValueFormatter<Date> P_DATE_FORMATTER = new ValueFormatter<Date>() {
        @Override
        public String format(Date value) {
            String result;
            if (value != null) {
                result = DF.format(value);
            } else {
                result = "";
            }
            return result;
        }
    };

    public RefElementVoisinageModel() {
        super(';');
        
        newMandatoryColumn("id_ref_infrastructure serial NOT NULL,", RefElementVoisinage.PROPERTY_ID_REF_INFRASTRUCTURE, INT_PARSER);
        newMandatoryColumn("iae_nom text,", RefElementVoisinage.PROPERTY_IAE_NOM);
        newMandatoryColumn("iae_surface_equivalente real,", RefElementVoisinage.PROPERTY_IAE_SURFACE_EQUIVALENTE, DOUBLE_PARSER);
        newMandatoryColumn("iae_remarque text,", RefElementVoisinage.PROPERTY_IAE_REMARQUE);
        newMandatoryColumn("p_dt_crea timestamp without time zone DEFAULT now(),", RefElementVoisinage.PROPERTY_P_DT_CREA, P_DATE_PARSER);
        newMandatoryColumn("p_dt_maj timestamp without time zone,", RefElementVoisinage.PROPERTY_P_DT_MAJ, P_DATE_PARSER);
        newMandatoryColumn("iae_no_ordre integer,", RefElementVoisinage.PROPERTY_IAE_NO_ORDRE, INT_PARSER);
        newMandatoryColumn("unite_surface character varying,", RefElementVoisinage.PROPERTY_UNITE_SURFACE);
        newMandatoryColumn("Source", RefElementVoisinage.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefElementVoisinage, Object>> getColumnsForExport() {
        ModelBuilder<RefElementVoisinage> modelBuilder = new ModelBuilder<RefElementVoisinage>();
        modelBuilder.newColumnForExport("id_ref_infrastructure serial NOT NULL,", RefElementVoisinage.PROPERTY_ID_REF_INFRASTRUCTURE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("iae_nom text,", RefElementVoisinage.PROPERTY_IAE_NOM);
        modelBuilder.newColumnForExport("iae_surface_equivalente real,", RefElementVoisinage.PROPERTY_IAE_SURFACE_EQUIVALENTE, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("iae_remarque text,", RefElementVoisinage.PROPERTY_IAE_REMARQUE);
        modelBuilder.newColumnForExport("p_dt_crea timestamp without time zone DEFAULT now(),", RefElementVoisinage.PROPERTY_P_DT_CREA, P_DATE_FORMATTER);
        modelBuilder.newColumnForExport("p_dt_maj timestamp without time zone,", RefElementVoisinage.PROPERTY_P_DT_MAJ, P_DATE_FORMATTER);
        modelBuilder.newColumnForExport("iae_no_ordre integer,", RefElementVoisinage.PROPERTY_IAE_NO_ORDRE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("unite_surface character varying,", RefElementVoisinage.PROPERTY_UNITE_SURFACE);
        modelBuilder.newColumnForExport("Source", RefElementVoisinage.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefElementVoisinage newEmptyInstance() {
        return new RefElementVoisinageImpl();
    }
}
