package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefDepartmentShapeModel.java 3232 2014-02-13 18:36:10Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefDepartmentShapeModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Iterator;

import org.nuiton.csv.ValueSetter;

import com.google.common.base.Splitter;

import fr.inra.agrosyst.api.entities.referential.RefDepartmentShape;
import fr.inra.agrosyst.api.entities.referential.RefDepartmentShapeImpl;

/**
 * @author David Cossé
 */
public class RefDepartmentShapeModel extends AbstractAgrosystModel<RefDepartmentShape> {

    public static final ValueSetter<RefDepartmentShape, String> SHAPE_LAT_LON_SETTER = new ValueSetter<RefDepartmentShape, String>() {
        @Override
        public void set(RefDepartmentShape shape, String geomXY) throws Exception {
            Iterable<String> split = Splitter.on(",").trimResults().omitEmptyStrings().split(geomXY);
            Iterator<String> coords = split.iterator();
            shape.setLatitude(DOUBLE_PARSER.parse(coords.next()));
            shape.setLongitude(DOUBLE_PARSER.parse(coords.next()));
        }
    };

    public RefDepartmentShapeModel() {
        super(';');

        newMandatoryColumn("geom_x_y", SHAPE_LAT_LON_SETTER);
        newMandatoryColumn("code_dept", RefDepartmentShape.PROPERTY_DEPARTMENT);
        newMandatoryColumn("geom", RefDepartmentShape.PROPERTY_SHAPE);
        newIgnoredColumn("id_geofla");
        newIgnoredColumn("nom_dept");
        newIgnoredColumn("code_chf");
        newIgnoredColumn("nom_chf");
        newIgnoredColumn("x_chf_lieu");
        newIgnoredColumn("y_chf_lieu");
        newIgnoredColumn("x_centroid");
        newIgnoredColumn("y_centroid");
        newIgnoredColumn("code_reg");
        newIgnoredColumn("nom_region");
    }

    @Override
    public RefDepartmentShape newEmptyInstance() {
        return new RefDepartmentShapeImpl();
    }
}
