package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefCouvSolPerenneModel.java 3006 2014-01-30 18:00:07Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefCouvSolPerenneModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.ParseException;

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenne;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenneImpl;

/**
 * Vitesse couv PHASE   Début Inter Fin Inter   Couv
 * 
 * @author Eric Chatellier
 */
public class RefCouvSolPerenneModel extends AbstractAgrosystModel<RefCouvSolPerenne> implements ExportModel<RefCouvSolPerenne> {

    protected static final ValueParser<CropCyclePhaseType> PHASE_PARSER = new ValueParser<CropCyclePhaseType>() {
        @Override
        public CropCyclePhaseType parse(String value) throws ParseException {
            CropCyclePhaseType result = CropCyclePhaseType.valueOf(value);
            return result;
        }
    };

    protected static final ValueFormatter<CropCyclePhaseType> PERIODE_SEMIS_FORMATTER = new ValueFormatter<CropCyclePhaseType>() {
        @Override
        public String format(CropCyclePhaseType value) {
            return value.name();
        }
    };

    public RefCouvSolPerenneModel() {
        super(';');

        newMandatoryColumn("Vitesse couv", RefCouvSolPerenne.PROPERTY_VITESSE_COUV, VITESSE_COUV_PARSER);
        newMandatoryColumn("PHASE", RefCouvSolPerenne.PROPERTY_PHASE, PHASE_PARSER);
        newMandatoryColumn("Début Inter", RefCouvSolPerenne.PROPERTY_DEBUT_INTER);
        newMandatoryColumn("Fin Inter", RefCouvSolPerenne.PROPERTY_FIN_INTER);
        newMandatoryColumn("Couv", RefCouvSolPerenne.PROPERTY_COUV, DOUBLE_PARSER);
    }

    @Override
    public Iterable<ExportableColumn<RefCouvSolPerenne, Object>> getColumnsForExport() {
        ModelBuilder<RefCouvSolPerenne> modelBuilder = new ModelBuilder<RefCouvSolPerenne>();
        modelBuilder.newColumnForExport("Vitesse couv", RefCouvSolPerenne.PROPERTY_VITESSE_COUV, VITESSE_COUV_FORMATTER);
        modelBuilder.newColumnForExport("PHASE", RefCouvSolPerenne.PROPERTY_PHASE, PERIODE_SEMIS_FORMATTER);
        modelBuilder.newColumnForExport("Début Inter", RefCouvSolPerenne.PROPERTY_DEBUT_INTER);
        modelBuilder.newColumnForExport("Fin Inter", RefCouvSolPerenne.PROPERTY_FIN_INTER);
        modelBuilder.newColumnForExport("Couv", RefCouvSolPerenne.PROPERTY_COUV, DOUBLE_FORMATTER);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
    
    @Override
    public RefCouvSolPerenne newEmptyInstance() {
        RefCouvSolPerenne result = new RefCouvSolPerenneImpl();
        return result;
    }
}
