package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefCouvSolAnnuelleModel.java 2965 2014-01-29 17:31:37Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefCouvSolAnnuelleModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.ParseException;

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

import fr.inra.agrosyst.api.entities.referential.PeriodeSemis;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelle;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelleImpl;

/**
 * Vitesse couv Période Semis   Début Inter Fin Inter   Couv
 * 
 * @author Eric Chatellier
 */
public class RefCouvSolAnnuelleModel extends AbstractAgrosystModel<RefCouvSolAnnuelle> implements ExportModel<RefCouvSolAnnuelle> {

    protected static final ValueParser<PeriodeSemis> PERIODE_SEMIS_PARSER = new ValueParser<PeriodeSemis>() {
        @Override
        public PeriodeSemis parse(String value) throws ParseException {
            PeriodeSemis result = PeriodeSemis.valueOf(value.replace('-', '_'));
            return result;
        }
    };

    protected static final ValueFormatter<PeriodeSemis> PERIODE_SEMIS_FORMATTER = new ValueFormatter<PeriodeSemis>() {
        @Override
        public String format(PeriodeSemis value) {
            return value.name();
        }
    };

    public RefCouvSolAnnuelleModel() {
        super(';');

        newMandatoryColumn("Vitesse couv", RefCouvSolAnnuelle.PROPERTY_VITESSE_COUV, VITESSE_COUV_PARSER);
        newMandatoryColumn("Période Semis", RefCouvSolAnnuelle.PROPERTY_PERIODE_SEMIS, PERIODE_SEMIS_PARSER);
        newMandatoryColumn("Début Inter", RefCouvSolAnnuelle.PROPERTY_DEBUT_INTER);
        newMandatoryColumn("Fin Inter", RefCouvSolAnnuelle.PROPERTY_FIN_INTER);
        newMandatoryColumn("Couv", RefCouvSolAnnuelle.PROPERTY_COUV, DOUBLE_PARSER);
    }

    @Override
    public Iterable<ExportableColumn<RefCouvSolAnnuelle, Object>> getColumnsForExport() {
        ModelBuilder<RefCouvSolAnnuelle> modelBuilder = new ModelBuilder<RefCouvSolAnnuelle>();
        modelBuilder.newColumnForExport("Vitesse couv", RefCouvSolAnnuelle.PROPERTY_VITESSE_COUV, VITESSE_COUV_FORMATTER);
        modelBuilder.newColumnForExport("Période Semis", RefCouvSolAnnuelle.PROPERTY_PERIODE_SEMIS, PERIODE_SEMIS_FORMATTER);
        modelBuilder.newColumnForExport("Début Inter", RefCouvSolAnnuelle.PROPERTY_DEBUT_INTER);
        modelBuilder.newColumnForExport("Fin Inter", RefCouvSolAnnuelle.PROPERTY_FIN_INTER);
        modelBuilder.newColumnForExport("Couv", RefCouvSolAnnuelle.PROPERTY_COUV, DOUBLE_FORMATTER);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
    
    @Override
    public RefCouvSolAnnuelle newEmptyInstance() {
        RefCouvSolAnnuelle result = new RefCouvSolAnnuelleImpl();
        return result;
    }
}
