package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefClonePlantGrapeModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefClonePlantGrapeModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrapeImpl;

public class RefClonePlantGrapeModel extends AbstractAgrosystModel<RefClonePlantGrape> implements ExportModel<RefClonePlantGrape> {

    public RefClonePlantGrapeModel() {
        super(';');
        newMandatoryColumn("CodeClone", RefClonePlantGrape.PROPERTY_CODE_CLONE, INT_PARSER);
        newMandatoryColumn("CodeVar", RefClonePlantGrape.PROPERTY_CODE_VAR, INT_PARSER);
        newMandatoryColumn("AnneeAgrement", RefClonePlantGrape.PROPERTY_ANNEE_AGREMENT, INT_PARSER);
        newMandatoryColumn("Origine", RefClonePlantGrape.PROPERTY_ORIGINE);
        newMandatoryColumn("source", RefClonePlantGrape.PROPERTY_SOURCE);
    }

    @Override
    public RefClonePlantGrape newEmptyInstance() {
        RefClonePlantGrapeImpl result = new RefClonePlantGrapeImpl();
        return result;
    }

    @Override
    public Iterable<ExportableColumn<RefClonePlantGrape, Object>> getColumnsForExport() {
        ModelBuilder<RefClonePlantGrape> modelBuilder = new ModelBuilder<RefClonePlantGrape>();
        modelBuilder.newColumnForExport("CodeClone", RefClonePlantGrape.PROPERTY_CODE_CLONE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("CodeVar", RefClonePlantGrape.PROPERTY_CODE_VAR, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("AnneeAgrement", RefClonePlantGrape.PROPERTY_ANNEE_AGREMENT, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("Origine", RefClonePlantGrape.PROPERTY_ORIGINE);
        modelBuilder.newColumnForExport("source", RefClonePlantGrape.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
