package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefAdventiceModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefAdventiceModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefAdventiceImpl;

/**
 * Modele d'import du référentiel Adventices.
 * 
 * <ul>
 * <li>adventice
 * <li>identifiant
 * <li>Famille de culture
 * <li>Source
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class RefAdventiceModel extends AbstractAgrosystModel<RefAdventice> implements ExportModel<RefAdventice> {

    public RefAdventiceModel() {
        super(';');
        
        newMandatoryColumn("adventice", RefAdventice.PROPERTY_ADVENTICE);
        newMandatoryColumn("identifiant", RefAdventice.PROPERTY_IDENTIFIANT);
        newMandatoryColumn("Famille de culture", RefAdventice.PROPERTY_FAMILLE_DE_CULTURE);
        newMandatoryColumn("Source", RefAdventice.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefAdventice, Object>> getColumnsForExport() {
        ModelBuilder<RefAdventice> modelBuilder = new ModelBuilder<RefAdventice>();
        modelBuilder.newColumnForExport("adventice", RefAdventice.PROPERTY_ADVENTICE);
        modelBuilder.newColumnForExport("identifiant", RefAdventice.PROPERTY_IDENTIFIANT);
        modelBuilder.newColumnForExport("Famille de culture", RefAdventice.PROPERTY_FAMILLE_DE_CULTURE);
        modelBuilder.newColumnForExport("Source", RefAdventice.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefAdventice newEmptyInstance() {
        return new RefAdventiceImpl();
    }
}
