package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaTraitementsProduitsCategModel.java 2761 2014-01-16 16:18:50Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefActaTraitementsProduitsCategModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCateg;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCategImpl;

/**
 * id_traitement, code_traitement, nom_traitement, action, type_intrant, type_produit, ift_total,
 * ift_tot_hts, ift_h, ift_f, ift_i, ift_ts, ift_a, ift_hh, ift_moy_bio, Source.
 * 
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class RefActaTraitementsProduitsCategModel extends AbstractAgrosystModel<RefActaTraitementsProduitsCateg> implements ExportModel<RefActaTraitementsProduitsCateg> {


    public RefActaTraitementsProduitsCategModel() {
        super(';');
        //id_produit;nom_produit;id_traitement;code_traitement;nom_traitement;Source
        newMandatoryColumn("id_traitement", RefActaTraitementsProduitsCateg.PROPERTY_ID_TRAITEMENT, INT_PARSER);
        newMandatoryColumn("code_traitement", RefActaTraitementsProduitsCateg.PROPERTY_CODE_TRAITEMENT);
        newMandatoryColumn("nom_traitement", RefActaTraitementsProduitsCateg.PROPERTY_NOM_TRAITEMENT);
        newMandatoryColumn("action", RefActaTraitementsProduitsCateg.PROPERTY_ACTION, AGROSYST_INTERVENTION_TYPE_PARSER);
        newIgnoredColumn("type_intrant");
        newMandatoryColumn("type_produit", RefActaTraitementsProduitsCateg.PROPERTY_TYPE_PRODUIT);
        newMandatoryColumn("ift_total", RefActaTraitementsProduitsCateg.PROPERTY_IFT_TOTAL, O_N_PARSER);
        newMandatoryColumn("ift_tot_hts", RefActaTraitementsProduitsCateg.PROPERTY_IFT_TOT_HTS, O_N_PARSER);
        newMandatoryColumn("ift_h", RefActaTraitementsProduitsCateg.PROPERTY_IFT_H, O_N_PARSER);
        newMandatoryColumn("ift_f", RefActaTraitementsProduitsCateg.PROPERTY_IFT_F, O_N_PARSER);
        newMandatoryColumn("ift_i", RefActaTraitementsProduitsCateg.PROPERTY_IFT_I, O_N_PARSER);
        newMandatoryColumn("ift_ts", RefActaTraitementsProduitsCateg.PROPERTY_IFT_TS, O_N_PARSER);
        newMandatoryColumn("ift_a", RefActaTraitementsProduitsCateg.PROPERTY_IFT_A, O_N_PARSER);
        newMandatoryColumn("ift_hh", RefActaTraitementsProduitsCateg.PROPERTY_IFT_HH, O_N_PARSER);
        newMandatoryColumn("ift_moy_bio", RefActaTraitementsProduitsCateg.PROPERTY_IFT_MOY_BIO, O_N_PARSER);
        newMandatoryColumn("Source", RefActaTraitementsProduitsCateg.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefActaTraitementsProduitsCateg, Object>> getColumnsForExport() {
        ModelBuilder<RefActaTraitementsProduitsCateg> modelBuilder = new ModelBuilder<RefActaTraitementsProduitsCateg>();
        modelBuilder.newColumnForExport("id_traitement", RefActaTraitementsProduitsCateg.PROPERTY_ID_TRAITEMENT, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("code_traitement", RefActaTraitementsProduitsCateg.PROPERTY_CODE_TRAITEMENT);
        modelBuilder.newColumnForExport("nom_traitement", RefActaTraitementsProduitsCateg.PROPERTY_NOM_TRAITEMENT);
        modelBuilder.newColumnForExport("action", RefActaTraitementsProduitsCateg.PROPERTY_ACTION, AGROSYST_INTERVENTION_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("type_produit", RefActaTraitementsProduitsCateg.PROPERTY_TYPE_PRODUIT);
        modelBuilder.newColumnForExport("ift_total", RefActaTraitementsProduitsCateg.PROPERTY_IFT_TOTAL, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_tot_hts", RefActaTraitementsProduitsCateg.PROPERTY_IFT_TOT_HTS, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_h", RefActaTraitementsProduitsCateg.PROPERTY_IFT_H, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_f", RefActaTraitementsProduitsCateg.PROPERTY_IFT_F, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_i", RefActaTraitementsProduitsCateg.PROPERTY_IFT_I, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_ts", RefActaTraitementsProduitsCateg.PROPERTY_IFT_TS, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_a", RefActaTraitementsProduitsCateg.PROPERTY_IFT_A, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_hh", RefActaTraitementsProduitsCateg.PROPERTY_IFT_HH, O_N_FORMATTER);
        modelBuilder.newColumnForExport("ift_moy_bio", RefActaTraitementsProduitsCateg.PROPERTY_IFT_MOY_BIO, O_N_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefActaTraitementsProduitsCateg.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefActaTraitementsProduitsCateg newEmptyInstance() {
        return new RefActaTraitementsProduitsCategImpl();
    }
}
