package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaTraitementsProduitModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefActaTraitementsProduitModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitImpl;

/**
 * id_produit, nom_produit, id_traitement, code_traitement, nom_traitement, NODU 2013, Source.
 * 
 * @author David Cossé
 */
public class RefActaTraitementsProduitModel extends AbstractAgrosystModel<RefActaTraitementsProduit> implements ExportModel<RefActaTraitementsProduit> {


    public RefActaTraitementsProduitModel() {
        super(';');
        //id_produit;nom_produit;id_traitement;code_traitement;nom_traitement;Source
        newMandatoryColumn("id_produit", RefActaTraitementsProduit.PROPERTY_ID_PRODUIT);
        newMandatoryColumn("nom_produit", RefActaTraitementsProduit.PROPERTY_NOM_PRODUIT);
        newMandatoryColumn("id_traitement", RefActaTraitementsProduit.PROPERTY_ID_TRAITEMENT, INT_PARSER);
        newMandatoryColumn("code_traitement", RefActaTraitementsProduit.PROPERTY_CODE_TRAITEMENT);
        newMandatoryColumn("nom_traitement", RefActaTraitementsProduit.PROPERTY_NOM_TRAITEMENT);
        newMandatoryColumn("NODU 2013", RefActaTraitementsProduit.PROPERTY_NODU, O_N_PARSER);
        newMandatoryColumn("Source", RefActaTraitementsProduit.PROPERTY_SOURCE);
    }

    @Override
    public Iterable<ExportableColumn<RefActaTraitementsProduit, Object>> getColumnsForExport() {
        ModelBuilder<RefActaTraitementsProduit> modelBuilder = new ModelBuilder<RefActaTraitementsProduit>();
        modelBuilder.newColumnForExport("id_produit", RefActaTraitementsProduit.PROPERTY_ID_PRODUIT);
        modelBuilder.newColumnForExport("nom_produit", RefActaTraitementsProduit.PROPERTY_NOM_PRODUIT);
        modelBuilder.newColumnForExport("id_traitement", RefActaTraitementsProduit.PROPERTY_ID_TRAITEMENT, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("code_traitement", RefActaTraitementsProduit.PROPERTY_CODE_TRAITEMENT);
        modelBuilder.newColumnForExport("nom_traitement", RefActaTraitementsProduit.PROPERTY_NOM_TRAITEMENT);
        modelBuilder.newColumnForExport("NODU 2013", RefActaTraitementsProduit.PROPERTY_NODU, O_N_FORMATTER);
        modelBuilder.newColumnForExport("Source", RefActaTraitementsProduit.PROPERTY_SOURCE);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefActaTraitementsProduit newEmptyInstance() {
        return new RefActaTraitementsProduitImpl();
    }
}
