package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaSubstanceActiveModel.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefActaSubstanceActiveModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActiveImpl;

/**
 * Référentiel Acta substance active.
 * 
 * id_produit;nom_produit;nom_commun_SA;concentration_valeur;concentration_unite;Source
 */
public class RefActaSubstanceActiveModel extends AbstractAgrosystModel<RefActaSubstanceActive> implements ExportModel<RefActaSubstanceActive> {

    public RefActaSubstanceActiveModel() {
        super(';');

        newMandatoryColumn("id_produit", RefActaSubstanceActive.PROPERTY_ID_PRODUIT);
        newMandatoryColumn("nom_produit", RefActaSubstanceActive.PROPERTY_NOM_PRODUIT);
        newMandatoryColumn("nom_commun_SA", RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA);
        newMandatoryColumn("concentration_valeur", RefActaSubstanceActive.PROPERTY_CONCENTRATION_VALEUR, DOUBLE_PARSER);
        newMandatoryColumn("concentration_unite", RefActaSubstanceActive.PROPERTY_CONCENTRATION_UNITE);
        newMandatoryColumn("Source", RefActaSubstanceActive.PROPERTY_SOURCE);
        newMandatoryColumn("Remarques", RefActaSubstanceActive.PROPERTY_REMARQUES);
    }

    @Override
    public Iterable<ExportableColumn<RefActaSubstanceActive, Object>> getColumnsForExport() {
        ModelBuilder<RefActaSubstanceActive> modelBuilder = new ModelBuilder<RefActaSubstanceActive>();
        modelBuilder.newColumnForExport("id_produit", RefActaSubstanceActive.PROPERTY_ID_PRODUIT);
        modelBuilder.newColumnForExport("nom_produit", RefActaSubstanceActive.PROPERTY_NOM_PRODUIT);
        modelBuilder.newColumnForExport("nom_commun_SA", RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA);
        modelBuilder.newColumnForExport("concentration_valeur", RefActaSubstanceActive.PROPERTY_CONCENTRATION_VALEUR, DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("concentration_unite", RefActaSubstanceActive.PROPERTY_CONCENTRATION_UNITE);
        modelBuilder.newColumnForExport("Source", RefActaSubstanceActive.PROPERTY_SOURCE);
        modelBuilder.newColumnForExport("Remarques", RefActaSubstanceActive.PROPERTY_REMARQUES);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefActaSubstanceActive newEmptyInstance() {
        return new RefActaSubstanceActiveImpl();
    }
}
