package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaGroupeCulturesModel.java 2802 2014-01-20 21:07:06Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/RefActaGroupeCulturesModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;

import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCultures;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCulturesImpl;

/**
 * Référentiel ActaGroupeCultures.
 * 
 * id_culture;nom_culture;id_groupe_culture;nom_groupe_culture
 */
public class RefActaGroupeCulturesModel extends AbstractAgrosystModel<RefActaGroupeCultures> implements ExportModel<RefActaGroupeCultures> {

    public RefActaGroupeCulturesModel() {
        super(';');

        newMandatoryColumn("id_culture", RefActaGroupeCultures.PROPERTY_ID_CULTURE, INT_PARSER);
        newMandatoryColumn("nom_culture", RefActaGroupeCultures.PROPERTY_NOM_CUTURE);
        newMandatoryColumn("id_groupe_culture", RefActaGroupeCultures.PROPERTY_ID_GROUPE_CULTURE, INT_PARSER);
        newMandatoryColumn("nom_groupe_culture", RefActaGroupeCultures.PROPERTY_NOM_GROUPE_CULTURE);
        newMandatoryColumn("Commentaires", RefActaGroupeCultures.PROPERTY_COMMENTAIRES);
    }

    @Override
    public Iterable<ExportableColumn<RefActaGroupeCultures, Object>> getColumnsForExport() {
        ModelBuilder<RefActaGroupeCultures> modelBuilder = new ModelBuilder<RefActaGroupeCultures>();
        modelBuilder.newColumnForExport("id_culture", RefActaGroupeCultures.PROPERTY_ID_CULTURE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("nom_culture", RefActaGroupeCultures.PROPERTY_NOM_CUTURE);
        modelBuilder.newColumnForExport("id_groupe_culture", RefActaGroupeCultures.PROPERTY_ID_GROUPE_CULTURE, INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("nom_groupe_culture", RefActaGroupeCultures.PROPERTY_NOM_GROUPE_CULTURE);
        modelBuilder.newColumnForExport("Commentaires", RefActaGroupeCultures.PROPERTY_COMMENTAIRES);
        return (Iterable) modelBuilder.getColumnsForExport();
    }

    @Override
    public RefActaGroupeCultures newEmptyInstance() {
        return new RefActaGroupeCulturesImpl();
    }
}
