package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: CommunesPostCodeOsmModel.java 3571 2014-03-03 15:23:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/CommunesPostCodeOsmModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * @author kmorin : kmorin@codelutin.com
 * @since 0.8
 */
public class CommunesPostCodeOsmModel extends AbstractAgrosystModel<RefLocationDto> {

    public CommunesPostCodeOsmModel() {
        super(';');

        newMandatoryColumn("INSEE_CODE", "codeInsee");
        newMandatoryColumn("REGION_CODE", "region", INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("DEPARTMENT", "departement");
        newMandatoryColumn("POSTAL_CODE", "codePostal");
        newMandatoryColumn("NAME", "nomCommune");
        newMandatoryColumn("LAT", "latitude", DOUBLE_PARSER);
        newMandatoryColumn("LON", "longitude", DOUBLE_PARSER);
    }

    @Override
    public RefLocationDto newEmptyInstance() {
        return new RefLocationDto();
    }

}
